/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TheJudgement
extends ItemBase {
    public static final float ATTACK_DAMAGE = Float.POSITIVE_INFINITY;
    public static final double ATTACK_RADIUS = 64.0;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public TheJudgement() {
        super(ItemBase.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41486_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", Double.POSITIVE_INFINITY, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", 28.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.m_9236_().f_46443_) {
            return false;
        }
        Level level = target.m_9236_();
        boolean player = attacker instanceof Player;
        AABB box = target.m_20191_().m_82400_(64.0);
        DamageSource source = player ? level.m_269111_().m_269075_((Player)attacker) : level.m_269111_().m_269333_(attacker);
        List targets = level.m_6443_(LivingEntity.class, box, e -> e != attacker && e != target && e.m_20280_((Entity)target) < 4096.0);
        targets.forEach(t -> t.m_6469_(source, Float.POSITIVE_INFINITY));
        if (this.noDrops(stack)) {
            List drops = level.m_6443_(Entity.class, box, e -> (e instanceof ItemEntity || e instanceof ExperienceOrb) && e.m_20280_((Entity)target) < 4096.0);
            drops.forEach(e -> e.m_6469_(source, Float.POSITIVE_INFINITY));
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        boolean prevNoDrops = this.noDrops(stack = player.m_21120_(hand));
        this.setNoDrops(stack, !prevNoDrops);
        world.m_5594_(null, player.m_20183_(), prevNoDrops ? EnigmaticSounds.CHARGED_OFF : EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, 1.0f, 0.8f + random.nextFloat() * 0.2f);
        player.m_6674_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public boolean m_5812_(ItemStack pStack) {
        return this.noDrops(pStack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            int mode = this.noDrops(stack) ? 1 : 0;
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theJudgement1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theJudgement2", ChatFormatting.GOLD, 64);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theJudgement3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theJudgement4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theJudgement5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theJudgement6", null, Component.m_237115_((String)("tooltip.enigmaticlegacy.theJudgementMode" + mode)));
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    private boolean noDrops(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, "noDrops", false);
    }

    private void setNoDrops(ItemStack stack, boolean value) {
        ItemNBTHelper.setBoolean(stack, "noDrops", value);
    }
}

