/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.aizistral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;

public class TheCube
extends ItemSpellstoneCurio
implements ISpellstone {
    private final List<MobEffect> randomBuffs;
    private final List<MobEffect> randomDebuffs;
    private final List<ResourceKey<Level>> worlds;
    private final Map<ServerPlayer, Future<CachedTeleportationLocation>> locationCache = new WeakHashMap<ServerPlayer, Future<CachedTeleportationLocation>>();
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public TheCube() {
        super(TheCube.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
        this.worlds = ImmutableList.of((Object)Level.f_46428_, (Object)Level.f_46429_, (Object)Level.f_46430_);
        this.randomBuffs = ImmutableList.of((Object)MobEffects.f_19617_, (Object)MobEffects.f_19600_, (Object)MobEffects.f_19605_, (Object)MobEffects.f_19598_, (Object)MobEffects.f_19603_, (Object)MobEffects.f_19596_, (Object)MobEffects.f_19606_, (Object)MobEffects.f_19591_);
        this.randomDebuffs = ImmutableList.of((Object)MobEffects.f_19610_, (Object)MobEffects.f_19604_, (Object)MobEffects.f_19599_, (Object)MobEffects.f_19612_, (Object)MobEffects.f_19620_, (Object)MobEffects.f_19597_, (Object)MobEffects.f_19613_, (Object)MobEffects.f_19614_, (Object)MobEffects.f_19615_);
        this.immunityList.add(DamageTypes.f_268468_);
        this.immunityList.add(DamageTypes.f_268631_);
        this.immunityList.add(DamageTypes.f_268546_);
        this.immunityList.add(DamageTypes.f_268434_);
        this.immunityList.add(DamageTypes.f_268613_);
        this.immunityList.add(DamageTypes.f_268722_);
        this.immunityList.add(DamageTypes.f_268671_);
        this.immunityList.add(DamageTypes.f_268576_);
        this.immunityList.add(DamageTypes.f_268585_);
        this.immunityList.add(DamageTypes.f_268612_);
        this.immunityList.add(DamageTypes.f_268659_);
        this.immunityList.add(DamageTypes.f_268469_);
    }

    @Override
    public int getCooldown(Player player) {
        if (player != null && reducedCooldowns.test(player)) {
            return 1600;
        }
        return 3200;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            boolean cursed = Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.isTheCursedOne((Player)Minecraft.m_91087_().f_91074_);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube3", ChatFormatting.GOLD, 120);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube11", ChatFormatting.GOLD, (int)this.getDamageLimit(cursed));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube12");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube13");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube14");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube15");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube16");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube17");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube18");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube19");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube20");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube21");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theCube22");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ChatFormatting.LIGHT_PURPLE, ((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void applyRandomEffect(LivingEntity entity, boolean positive) {
        List<MobEffect> effects = positive ? this.randomBuffs : this.randomDebuffs;
        MobEffect effect = effects.get(random.nextInt(effects.size()));
        if (positive) {
            int time = 100 + random.nextInt(500);
            int amplifier = random.nextDouble() <= 0.25 ? 1 : 0;
            entity.m_7292_(new MobEffectInstance(effect, time, amplifier, false, true));
        } else {
            int time = 200 + random.nextInt(1000);
            int amplifier = random.nextDouble() <= 0.15 ? 2 : (random.nextDouble() <= 0.4 ? 1 : 0);
            entity.m_7292_(new MobEffectInstance(effect, time, amplifier, false, true));
        }
    }

    public float getDamageLimit(Player player) {
        return this.getDamageLimit(SuperpositionHandler.isTheCursedOne(player));
    }

    private float getDamageLimit(boolean cursed) {
        return cursed ? 150.0f : 100.0f;
    }

    public Multimap<Attribute, AttributeModifier> getCurrentModifiers(Player player) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("a601a528-fbf3-49bb-84af-f65023c1a188"), "enigmaticlegacy:sprint_bonus", player.m_20142_() ? (double)0.35f : 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributes;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("d171890c-ba68-42e3-ba2e-ac275e8de595"), "enigmaticlegacy:attack_speed_modifier", (double)0.4f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributes.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(UUID.fromString("7652a7d5-1e7c-4c8e-8bd2-b0dd38411581"), "enigmaticlegacy:swim_bonus", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributes.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("290d5f76-87aa-4f7c-9c1a-9aef2fe25d05"), "enigmaticlegacy:luck_bonus", 1.0, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        return super.getFortuneLevel(slotContext, lootContext, stack) + 1;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    @Override
    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AttributeMap map = player.m_21204_();
            map.m_22161_(this.getCurrentModifiers(player));
        }
    }

    @Override
    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_20146_() < 300) {
                player.m_20301_(300);
            }
            if (player.m_6060_()) {
                player.m_20095_();
            }
            AttributeMap map = player.m_21204_();
            map.m_22178_(this.getCurrentModifiers(player));
            if (context.entity() instanceof ServerPlayer) {
                if (!this.locationCache.containsKey(player)) {
                    this.generateCachedLocation((ServerPlayer)player);
                } else {
                    Future<CachedTeleportationLocation> future = this.locationCache.get(player);
                    if (future.isDone() && !future.isCancelled()) {
                        try {
                            CachedTeleportationLocation location = future.get();
                            if (location.dimension() == player.m_9236_().m_46472_()) {
                                this.generateCachedLocation((ServerPlayer)player);
                            }
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void triggerActiveAbility(Level world, ServerPlayer player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((Player)player)) {
            return;
        }
        CachedTeleportationLocation location = null;
        if (this.locationCache.containsKey(player)) {
            try {
                Future<CachedTeleportationLocation> future = this.locationCache.get(player);
                if (future.isDone()) {
                    location = this.locationCache.get(player).get();
                } else {
                    future.cancel(true);
                }
                this.locationCache.remove(player);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (location == null) {
            EnigmaticLegacy.LOGGER.getInternal().info("No cached location found for {}, generating new one synchronously.", (Object)player.m_36316_().getName());
            location = this.findRandomLocation(player);
        }
        ResourceKey<Level> key = location.dimension();
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 128.0, player.m_9236_().m_46472_())), (Object)new PacketRecallParticles(player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), 48, false));
        player.m_6021_(location.x(), location.y(), location.z());
        if (player.m_9236_().m_46472_() != key) {
            SuperpositionHandler.sendToDimension(player, key);
            player.m_6021_(location.x(), location.y(), location.z());
        }
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 128.0, player.m_9236_().m_46472_())), (Object)new PacketRecallParticles(player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), 48, false));
        SuperpositionHandler.setSpellstoneCooldown((Player)player, this.getCooldown((Player)player));
        EnigmaticLegacy.LOGGER.getInternal().info("Player {} triggered active ability of Non-Euclidean Cube. Teleported to D: {}, X: {}, Y: {}, Z: {}.", (Object)player.m_36316_().getName(), (Object)player.m_9236_().m_46472_(), (Object)player.m_20185_(), (Object)player.m_20186_(), (Object)player.m_20189_());
    }

    private void generateCachedLocation(ServerPlayer player) {
        Future<CachedTeleportationLocation> future = this.executor.submit(() -> {
            try {
                CachedTeleportationLocation location = this.findRandomLocation(player);
                EnigmaticLegacy.LOGGER.debug("Found random location: " + location);
                return location;
            }
            catch (Exception ex) {
                EnigmaticLegacy.LOGGER.error("Could not find random location for:" + player.m_36316_().getName());
                ex.printStackTrace();
                throw ex;
            }
        });
        this.locationCache.put(player, future);
    }

    private CachedTeleportationLocation findRandomLocation(ServerPlayer player) {
        ResourceKey key = SuperpositionHandler.getRandomElement(this.worlds, player.m_9236_().m_46472_());
        ServerLevel level = SuperpositionHandler.getWorld((ResourceKey<Level>)key);
        if (level == null) {
            EnigmaticLegacy.LOGGER.error("Could not find world: " + key);
            EnigmaticLegacy.LOGGER.error("This is never supposed to happen!");
            key = Level.f_46428_;
            level = SuperpositionHandler.getOverworld();
        }
        int border = (int)level.m_6857_().m_61959_() / 2;
        int attempts = 0;
        int radius = border < 10000 ? border : 10000;
        do {
            BlockPos pos = new BlockPos(radius - random.nextInt(radius * 2), key == Level.f_46429_ ? 100 : 200, radius - random.nextInt(radius * 2));
            level.m_46745_(pos);
            for (int i = 0; i < 4; ++i) {
                Optional<Vector3> location;
                if (i > 0) {
                    pos = new BlockPos((pos.m_123341_() >> 4) * 16 + random.nextInt(16), pos.m_123342_(), (pos.m_123343_() >> 4) * 16 + random.nextInt(16));
                }
                if ((location = this.findValidPosition(player, (Level)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).isEmpty()) continue;
                return new CachedTeleportationLocation((ResourceKey<Level>)key, location.get().x, location.get().y, location.get().z);
            }
        } while (++attempts <= 100);
        return this.findRandomLocation(player);
    }

    private Optional<Vector3> findValidPosition(ServerPlayer player, Level world, int x, int y, int z) {
        int checkAxis = y - 10;
        for (int counter = 0; counter <= checkAxis; ++counter) {
            BlockPos below = new BlockPos(x, y - counter - 1, z);
            BlockPos feet = new BlockPos(x, y - counter, z);
            BlockPos head = new BlockPos(x, y - counter + 1, z);
            if (world.m_141937_() >= below.m_123342_()) {
                return Optional.empty();
            }
            if (world.m_46859_(below) || !world.m_8055_(below).m_60815_() || !world.m_46859_(feet) || !world.m_46859_(head)) continue;
            return Optional.of(new Vector3((double)feet.m_123341_() + 0.5, feet.m_123342_(), (double)feet.m_123343_() + 0.5));
        }
        return Optional.empty();
    }

    public void clearLocationCache() {
        this.locationCache.clear();
    }

    private record CachedTeleportationLocation(ResourceKey<Level> dimension, double x, double y, double z) {
    }
}

