/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICreativeTabMember;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class EldritchPan
extends TieredItem
implements Vanishable,
ICursed,
ICreativeTabMember {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("2d5cac0e-598f-475b-97cb-c7ab4741d0f5");
    private static final ItemStack UNSUSPECTING_DIAMOND_SWORD = new ItemStack((ItemLike)Items.f_42388_);
    public static final Map<Player, Integer> HOLDING_DURATIONS = new WeakHashMap<Player, Integer>();
    public static Omniconfig.DoubleParameter attackDamage = null;
    public static Omniconfig.DoubleParameter attackSpeed = null;
    public static Omniconfig.DoubleParameter armorValue = null;
    public static Omniconfig.DoubleParameter lifeSteal = null;
    public static Omniconfig.DoubleParameter hungerSteal = null;
    public static Omniconfig.DoubleParameter uniqueDamageGain = null;
    public static Omniconfig.DoubleParameter uniqueArmorGain = null;
    public static Omniconfig.IntParameter uniqueGainLimit = null;
    private final Multimap<Attribute, AttributeModifier> defaultMainhandModifiers;
    private final Multimap<Attribute, AttributeModifier> defaultOffhandModifiers;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EldritchPan");
        attackDamage = builder.comment("The base attack damage of The Voracious Pan.").max(32768.0).getDouble("AttackDamage", 31.0);
        attackSpeed = builder.comment("The base attack speed of The Voracious Pan.").minMax(32768.0).getDouble("AttackSpeed", -3.2);
        armorValue = builder.comment("The base armor value of The Voracious Pan.").max(32768.0).getDouble("ArmorValue", 4.0);
        lifeSteal = builder.comment("Base Lifesteal fraction of The Voracious Pan.").max(32768.0).getDouble("LifeSteal", 0.15);
        hungerSteal = builder.comment("Base Hungersteal value of The Voracious Pan.").max(32768.0).getDouble("HungerSteal", 2.0);
        uniqueDamageGain = builder.comment("Base damage gain from unique mob kills for The Voracious Pan.").max(32768.0).getDouble("UniqueDamageGain", 0.5);
        uniqueArmorGain = builder.comment("Base armor gain from unique mob kills for The Voracious Pan.").max(32768.0).getDouble("UniqueArmorGain", 0.5);
        uniqueGainLimit = builder.comment("How many unique mob kills will count towards increasing the stats of The Voracious Pan.").max(32768.0).getInt("UniqueGainLimit", 100);
        builder.popPrefix();
    }

    public EldritchPan() {
        super((Tier)EnigmaticMaterials.ELDRITCH_PAN, ItemBaseTool.getDefaultProperties().m_41499_(4000).m_41497_(Rarity.EPIC).m_41486_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", attackDamage.getValue(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", attackSpeed.getValue(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID, "Weapon modifier", armorValue.getValue(), AttributeModifier.Operation.ADDITION));
        this.defaultMainhandModifiers = builder.build();
        builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID, "Weapon modifier", armorValue.getValue(), AttributeModifier.Operation.ADDITION));
        this.defaultOffhandModifiers = builder.build();
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND) {
            return super.m_7167_(slot);
        }
        return slot == EquipmentSlot.MAINHAND ? this.defaultMainhandModifiers : this.defaultOffhandModifiers;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND) {
            return super.m_7167_(slot);
        }
        int kills = EldritchPan.getKillCount(stack);
        if (kills <= 0) {
            return super.getAttributeModifiers(slot, stack);
        }
        double armor = armorValue.getValue() + uniqueArmorGain.getValue() * (double)kills;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID, "Weapon modifier", armor, AttributeModifier.Operation.ADDITION));
        if (slot != EquipmentSlot.MAINHAND) {
            return builder.build();
        }
        double damage = attackDamage.getValue() + uniqueDamageGain.getValue() * (double)kills;
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", attackSpeed.getValue(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", damage, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.m_217043_().m_188500_() < 1.0E-4) {
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), EnigmaticSounds.PAN_CLANG_FR, SoundSource.PLAYERS, 1.0f, attacker.m_9236_().f_46441_.m_188501_() * 0.2f + 0.8f);
        } else {
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), EnigmaticSounds.PAN_CLANG, SoundSource.PLAYERS, 0.5f, attacker.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, entity, living -> living.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            String life = "+" + this.toString(100.0 * lifeSteal.getValue()) + "%";
            String hunger = "+" + this.toString(hungerSteal.getValue());
            String damageGain = "+" + this.toString(uniqueDamageGain.getValue());
            String armorGain = "+" + this.toString(uniqueArmorGain.getValue());
            boolean noHunger = SuperpositionHandler.cannotHunger(EnigmaticLegacy.PROXY.getClientPlayer());
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan1");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan2");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan3", ChatFormatting.GOLD, life);
            if (!noHunger) {
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan4", ChatFormatting.GOLD, hunger);
            } else {
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan4_alt", ChatFormatting.GOLD, hunger);
            }
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan5");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan6");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            if (!noHunger) {
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan7");
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan8");
            } else {
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan7_alt");
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan8_alt");
                ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan8p_alt");
            }
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan9", ChatFormatting.GOLD, damageGain);
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPan10", ChatFormatting.GOLD, armorGain);
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateWorthyOnesOnly(tooltip);
        } else {
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPanLore1");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.holdShift");
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            this.writeKillCount(tooltip, stack);
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateCursedOnesOnly(tooltip);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack offhandStack;
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && (offhandStack = player.m_21206_()).m_41720_().m_6164_(offhandStack) == UseAnim.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (SuperpositionHandler.isTheCursedOne(player)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    private void writeKillCount(List<Component> tooltip, ItemStack pan) {
        int kills = EldritchPan.getKillCount(pan);
        ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPanKills1", ChatFormatting.GOLD, kills);
        if (kills >= uniqueGainLimit.getValue()) {
            ItemLoreHelper.addLocalizedString(tooltip, "tooltip.enigmaticlegacy.eldritchPanKillsMax");
        }
    }

    @Override
    @Nullable
    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.MAIN;
    }

    private String toString(double value) {
        if (Math.floor(value) == value) {
            return Integer.toString((int)value);
        }
        return Double.toString(value);
    }

    public static int getKillCount(ItemStack pan) {
        CompoundTag tag = pan.m_41783_();
        if (tag == null || !tag.m_128425_("PanUniqueKills", 9)) {
            return 0;
        }
        ListTag list = tag.m_128437_("PanUniqueKills", 8);
        return list.size();
    }

    public static List<ResourceLocation> getUniqueKills(ItemStack pan) {
        CompoundTag tag = pan.m_41783_();
        if (tag == null || !tag.m_128425_("PanUniqueKills", 9)) {
            return Collections.emptyList();
        }
        ListTag list = tag.m_128437_("PanUniqueKills", 8);
        return list.stream().map(e -> new ResourceLocation(((StringTag)e).m_7916_())).toList();
    }

    public static void setUniqueKills(ItemStack pan, List<ResourceLocation> mobs) {
        CompoundTag tag = pan.m_41784_();
        ListTag list = new ListTag();
        mobs.forEach(entity -> list.add((Object)StringTag.m_129297_((String)entity.toString())));
        tag.m_128365_("PanUniqueKills", (Tag)list);
        pan.m_41751_(tag);
    }

    public static void addUniqueKill(ItemStack pan, ResourceLocation mob) {
        CompoundTag tag = pan.m_41784_();
        ListTag list = !tag.m_128425_("PanUniqueKills", 9) ? new ListTag() : tag.m_128437_("PanUniqueKills", 8);
        list.add((Object)StringTag.m_129297_((String)mob.toString()));
        tag.m_128365_("PanUniqueKills", (Tag)list);
        pan.m_41751_(tag);
    }

    public static boolean addKillIfNotPresent(ItemStack pan, ResourceLocation mob) {
        List<ResourceLocation> kills = EldritchPan.getUniqueKills(pan);
        if (kills.size() < 100 && !kills.contains(mob)) {
            EldritchPan.addUniqueKill(pan, mob);
            return true;
        }
        return false;
    }

    public static Ingredient getRepairMaterial() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42579_, Items.f_42485_, Items.f_42658_, Items.f_42583_, Items.f_42410_, Items.f_42436_, Items.f_42437_, Items.f_42675_});
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 24;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return Items.f_42388_.isBookEnchantable(UNSUSPECTING_DIAMOND_SWORD, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return Items.f_42388_.canApplyAtEnchantingTable(UNSUSPECTING_DIAMOND_SWORD, enchantment);
    }
}

