/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.registry;

import com.ibarnstormer.gbd.network.BeamReactorRayTracePacket;
import com.ibarnstormer.gbd.network.BroadcastBeamReactorSoundPacket;
import com.ibarnstormer.gbd.network.BroadcastTurretBeamSoundPacket;
import com.ibarnstormer.gbd.network.IModPacket;
import com.ibarnstormer.gbd.network.ToggleBeamReactorPacket;
import com.ibarnstormer.gbd.network.UpdatePlayerCapabilitiesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModNetwork {
    public static SimpleChannel ModChannel;

    public static void initNetwork() {
        ModChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("creategbd", "network"), () -> "1.0", s -> true, s -> true);
        ModChannel.registerMessage(0, UpdatePlayerCapabilitiesPacket.class, UpdatePlayerCapabilitiesPacket::send, UpdatePlayerCapabilitiesPacket::new, UpdatePlayerCapabilitiesPacket::handle);
        ModChannel.registerMessage(1, BeamReactorRayTracePacket.class, BeamReactorRayTracePacket::send, BeamReactorRayTracePacket::new, BeamReactorRayTracePacket::handle);
        ModChannel.registerMessage(2, ToggleBeamReactorPacket.class, ToggleBeamReactorPacket::send, ToggleBeamReactorPacket::new, ToggleBeamReactorPacket::handle);
        ModChannel.registerMessage(3, BroadcastBeamReactorSoundPacket.class, BroadcastBeamReactorSoundPacket::send, BroadcastBeamReactorSoundPacket::new, BroadcastBeamReactorSoundPacket::handle);
        ModChannel.registerMessage(4, BroadcastTurretBeamSoundPacket.class, BroadcastTurretBeamSoundPacket::send, BroadcastTurretBeamSoundPacket::new, BroadcastTurretBeamSoundPacket::handle);
    }

    public static void sendToPlayer(ServerPlayer sender, IModPacket packet) {
        ModChannel.send(PacketDistributor.PLAYER.with(() -> sender), (Object)packet);
    }

    public static void sendPacketToServer(IModPacket packet) {
        ModChannel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    public static void sendToNearbyPlayers(ServerPlayer sender, IModPacket packet, double radius, boolean excludeSender) {
        ModChannel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((ServerPlayer)(excludeSender ? sender : null), sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), radius, sender.m_9236_().m_46472_())), (Object)packet);
    }

    public static void sendToNearbyPlayersRaw(Vec3 pos, IModPacket packet, double radius, Level level) {
        ModChannel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, level.m_46472_())), (Object)packet);
    }
}

