/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.network;

import com.ibarnstormer.gbd.capability.ModCapabilityProvider;
import com.ibarnstormer.gbd.event.ModEvents;
import com.ibarnstormer.gbd.network.IModPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ToggleBeamReactorPacket
implements IModPacket {
    boolean toggle;

    public ToggleBeamReactorPacket(boolean toggle) {
        this.toggle = toggle;
    }

    public ToggleBeamReactorPacket(FriendlyByteBuf buf) {
        this.toggle = buf.readBoolean();
    }

    @Override
    public void send(FriendlyByteBuf buf) {
        buf.writeBoolean(this.toggle);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
                    if (cap.canToggle()) {
                        cap.setActive(this.toggle);
                    }
                    ModEvents.syncPlayerData((Player)player, false);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

