/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.block;

import com.ibarnstormer.gbd.block.TurretModeSlot;
import com.ibarnstormer.gbd.entities.TurretBeamLaserEntity;
import com.ibarnstormer.gbd.network.BroadcastTurretBeamSoundPacket;
import com.ibarnstormer.gbd.registry.ModIcons;
import com.ibarnstormer.gbd.registry.ModNetwork;
import com.ibarnstormer.gbd.utils.ProtectedScrollOptionBehaviour;
import com.ibarnstormer.gbd.utils.Utils;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuardianBeamTurretBlockEntity
extends KineticBlockEntity {
    protected ProtectedScrollOptionBehaviour<LaserTargetingConditions> targetingConditions;
    private final HashMap<LivingEntity, TurretBeamLaserEntity> targetPairs = new HashMap();
    private final int MAP_SIZE;
    private final int MAX_RANGE;
    private final int MOB_DAMAGE;
    private final int MAGIC_DAMAGE;
    private final boolean IGNORE_INVUL_FRAMES;
    @Nullable
    private UUID ownerUUID;

    protected AbstractGuardianBeamTurretBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state, int maxTargets, int maxRange, int mobDamage, int magicDamage, boolean ignoreInvulFrames) {
        super(typeIn, pos, state);
        this.MAP_SIZE = maxTargets;
        this.MAX_RANGE = maxRange;
        this.MOB_DAMAGE = mobDamage;
        this.MAGIC_DAMAGE = magicDamage;
        this.IGNORE_INVUL_FRAMES = ignoreInvulFrames;
    }

    public void tick() {
        super.tick();
        BlockPos pos = this.m_58899_();
        assert (this.f_58857_ != null);
        if (this.targetingConditions.getOwnerUUID() == null && this.ownerUUID != null) {
            this.targetingConditions.updateOwner(this.ownerUUID);
        }
        if (this.f_58857_.m_7702_(pos) instanceof AbstractGuardianBeamTurretBlockEntity) {
            BlockState state = this.f_58857_.m_8055_(pos);
            if ((double)Math.abs(this.getSpeed()) >= (Double)AllConfigs.server().kinetics.mediumSpeed.get()) {
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                    this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 2);
                }
                float chargeSpeed = Math.max(190L - Math.round(Math.log(Math.abs(this.getSpeed())) / Math.log(2.0)) * 20L, 30L);
                if (this.targetPairs.size() < this.MAP_SIZE) {
                    AABB box = new AABB(pos).m_82400_((double)this.MAX_RANGE);
                    List list = this.f_58857_.m_45976_(LivingEntity.class, box);
                    Entity owner = this.ownerUUID != null && !this.f_58857_.f_46443_ ? ((ServerLevel)this.f_58857_).m_8791_(this.ownerUUID) : null;
                    for (LivingEntity target : list) {
                        if (!this.targetPairs.containsKey(target) && !target.m_21224_() && this.parseTargetCriteria(target, this.f_58857_) && Utils.hasLOS(target, pos, this.f_58857_) && !Utils.isTeammate(owner, (Entity)target)) {
                            TurretBeamLaserEntity laser = new TurretBeamLaserEntity(this.f_58857_, target, (BlockEntity)this, chargeSpeed, this.MAX_RANGE, this.MAGIC_DAMAGE, this.MOB_DAMAGE, this.IGNORE_INVUL_FRAMES);
                            laser.m_146884_(pos.m_252807_());
                            if (!this.f_58857_.f_46443_) {
                                this.f_58857_.m_7967_((Entity)laser);
                            }
                            this.targetPairs.put(target, laser);
                        }
                        if (this.targetPairs.size() < this.MAP_SIZE) continue;
                        break;
                    }
                }
                Iterator<LivingEntity> targetIterator = this.targetPairs.keySet().iterator();
                while (targetIterator.hasNext()) {
                    Entity owner;
                    LivingEntity target = targetIterator.next();
                    TurretBeamLaserEntity laser = this.targetPairs.get(target);
                    if (laser.getTick() % 10 == 0 && !this.f_58857_.f_46443_) {
                        ModNetwork.sendToNearbyPlayersRaw(pos.m_252807_(), new BroadcastTurretBeamSoundPacket(laser.m_19879_()), 50.0, this.f_58857_);
                    }
                    if ((float)laser.getTick() >= laser.getChargeSpeed() + 1.0f && this.ownerUUID != null && target.m_21224_() && !this.f_58857_.f_46443_ && (owner = ((ServerLevel)this.f_58857_).m_8791_(this.ownerUUID)) instanceof Player) {
                        Player player = (Player)owner;
                        player.m_6756_(target.m_213860_());
                    }
                    if (!this.discardConditions(laser, target, pos.m_252807_(), this.f_58857_)) continue;
                    targetIterator.remove();
                }
            } else if (Math.abs(this.getSpeed()) == 0.0f || !this.hasSource()) {
                if (!this.f_58857_.f_46443_ && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                    this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE), 2);
                }
                if (!this.targetPairs.isEmpty()) {
                    this.targetPairs.clear();
                }
            } else if (!this.f_58857_.f_46443_ && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE), 2);
            }
        }
    }

    public void remove() {
        super.remove();
        if (!this.targetPairs.isEmpty()) {
            this.targetPairs.clear();
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.ownerUUID != null) {
            compound.m_128362_("ownerUUID", this.ownerUUID);
        }
        super.write(compound, clientPacket);
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        if (compound.m_128441_("ownerUUID")) {
            this.ownerUUID = compound.m_128342_("ownerUUID");
        }
        super.read(compound, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.targetingConditions = new ProtectedScrollOptionBehaviour<LaserTargetingConditions>(LaserTargetingConditions.class, (Component)Component.m_237115_((String)"creategbd.turret_beam_targeting_options"), (SmartBlockEntity)this, (ValueBoxTransform)new TurretModeSlot(), this.ownerUUID);
        behaviours.add((BlockEntityBehaviour)this.targetingConditions);
    }

    public void setOwner(Entity owner) {
        this.ownerUUID = owner.m_20148_();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    private boolean discardConditions(TurretBeamLaserEntity laser, LivingEntity target, Vec3 center, Level level) {
        return (float)laser.getTick() >= laser.getChargeSpeed() + 5.0f || laser.m_213877_() || target.m_21224_() || !Utils.hasLOS(target, BlockPos.m_274446_((Position)center), level);
    }

    private boolean parseTargetCriteria(LivingEntity target, Level level) {
        Player player;
        TamableAnimal tamable;
        Entity owner;
        if (this.ownerUUID != null && !level.f_46443_ && ((owner = ((ServerLevel)level).m_8791_(this.ownerUUID)) == target || target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_269323_() == owner)) {
            return false;
        }
        boolean isEnemy = target instanceof Enemy;
        boolean isPassive = target instanceof Animal || target instanceof AmbientCreature || target instanceof AbstractVillager;
        boolean isPlayer = target instanceof Player && !(player = (Player)target).m_5833_() && !player.m_7500_();
        switch ((LaserTargetingConditions)this.targetingConditions.get()) {
            case HOSTILE: {
                return isEnemy;
            }
            case PASSIVE: {
                return isPassive;
            }
            case PLAYER: {
                return isPlayer;
            }
            case HOSTILE_PLAYER: {
                return isEnemy || isPlayer;
            }
            case HOSTILE_PASSIVE: {
                return isEnemy || isPassive;
            }
            case PLAYER_PASSIVE: {
                return isPlayer || isPassive;
            }
            case EVERYTHING: {
                return !(target instanceof Player) || isPlayer;
            }
        }
        return false;
    }

    public static enum LaserTargetingConditions implements INamedIconOptions
    {
        HOSTILE(ModIcons.I_HOSTILE),
        PASSIVE(ModIcons.I_PASSIVE),
        PLAYER(ModIcons.I_PLAYER),
        HOSTILE_PASSIVE(ModIcons.I_HOSTILE_PASSIVE),
        HOSTILE_PLAYER(ModIcons.I_HOSTILE_PLAYER),
        PLAYER_PASSIVE(ModIcons.I_PLAYER_PASSIVE),
        EVERYTHING(ModIcons.I_EVERYTHING);

        private final String translationKey;
        private final ModIcons icon;

        private LaserTargetingConditions(ModIcons icon) {
            this.icon = icon;
            this.translationKey = "turret.targeting." + CreateLang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

