/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.fixes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class BytecodeFixerJarGenerator {
    private static final long ZIP_TIME = 318211200000L;
    private static final String MIXIN_CONFIG_NAME = "adapter.mixins.json";
    private static final String PACAKGE = "dev/su5ed/sinytra/connector/adapter/fieldtypepatch/mixin";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, ClassNode> generatedClasses = new HashMap<String, ClassNode>();

    public void loadExisting(Path path) {
        try (JarInputStream jis = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                byte[] bytes = jis.readAllBytes();
                ClassReader reader = new ClassReader(bytes);
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                this.generatedClasses.put(node.name, node);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error opening jar", e);
        }
    }

    public boolean save(Path path, Attributes additionalAttributes) {
        boolean bl;
        if (this.generatedClasses.isEmpty()) {
            return false;
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("MixinConfigs", MIXIN_CONFIG_NAME);
        manifest.getMainAttributes().putAll((Map<?, ?>)additionalAttributes);
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(path.toFile()), manifest);
        try {
            for (Map.Entry<String, ClassNode> entry : this.generatedClasses.entrySet()) {
                JarEntry jarEntry = new JarEntry(entry.getKey() + ".class");
                jarEntry.setTime(318211200000L);
                jos.putNextEntry(jarEntry);
                ClassWriter cw = new ClassWriter(3);
                entry.getValue().accept((ClassVisitor)cw);
                byte[] bytes = cw.toByteArray();
                jos.write(bytes);
                jos.closeEntry();
            }
            JarEntry configEntry = new JarEntry(MIXIN_CONFIG_NAME);
            configEntry.setTime(318211200000L);
            jos.putNextEntry(configEntry);
            jos.write(this.generateMixinConfig());
            jos.closeEntry();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        jos.close();
        return bl;
    }

    public ClassNode getOrCreateClass(String name, Function<String, ClassNode> generator) {
        return this.generatedClasses.computeIfAbsent("dev/su5ed/sinytra/connector/adapter/fieldtypepatch/mixin/" + name, generator);
    }

    private byte[] generateMixinConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("required", Boolean.valueOf(true));
        json.addProperty("minVersion", "0.8.5");
        json.addProperty("package", PACAKGE.replace('/', '.'));
        json.addProperty("compatibilityLevel", "JAVA_17");
        JsonArray array = new JsonArray();
        for (String name : this.generatedClasses.keySet()) {
            String shortName = name.replace("dev/su5ed/sinytra/connector/adapter/fieldtypepatch/mixin/", "");
            array.add(shortName.replace('/', '.'));
        }
        json.add("mixins", (JsonElement)array);
        String jsonString = GSON.toJson((JsonElement)json);
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }
}

