/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis;

import com.google.common.collect.ArrayListMultimap;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.LocalVariableNode;

public final class LocalVarRearrangement {
    @Nullable
    public static Int2IntMap getRearrangedParametersFromLocals(List<LocalVariableNode> cleanLocals, List<LocalVariableNode> dirtyLocals) {
        return LocalVarRearrangement.getRearrangedParameters(cleanLocals.stream().map(IndexedType::fromLocalVar).toList(), dirtyLocals.stream().map(IndexedType::fromLocalVar).toList());
    }

    @Nullable
    public static Int2IntMap getRearrangedParameters(List<IndexedType> parameterTypes, List<IndexedType> newParameterTypes) {
        List<IndexedType> sortedParameterTypes = parameterTypes.stream().sorted(Comparator.comparingInt(IndexedType::index)).toList();
        List<IndexedType> sortedNewParameterTypes = newParameterTypes.stream().sorted(Comparator.comparingInt(IndexedType::index)).toList();
        Object2IntOpenHashMap typeCount = new Object2IntOpenHashMap();
        ArrayListMultimap typeIndices = ArrayListMultimap.create();
        for (IndexedType indexedType : sortedParameterTypes) {
            typeCount.put((Object)indexedType.type(), typeCount.getInt((Object)indexedType.type()) + 1);
            typeIndices.put((Object)indexedType.type(), (Object)indexedType.index());
        }
        Object2IntOpenHashMap newTypeCount = new Object2IntOpenHashMap();
        for (IndexedType local : sortedNewParameterTypes) {
            newTypeCount.put((Object)local.type(), newTypeCount.getInt((Object)local.type()) + 1);
        }
        for (Object2IntMap.Entry entry : typeCount.object2IntEntrySet()) {
            if (newTypeCount.getInt(entry.getKey()) == entry.getIntValue()) continue;
            return null;
        }
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        Int2IntLinkedOpenHashMap swaps = new Int2IntLinkedOpenHashMap();
        for (IndexedType local : sortedNewParameterTypes) {
            if (!typeIndices.containsKey((Object)local.type())) continue;
            List indices = typeIndices.get((Object)local.type());
            int seen = object2IntOpenHashMap.getInt((Object)local.type());
            int oldIndex = (Integer)indices.get(seen);
            object2IntOpenHashMap.put((Object)local.type(), seen + 1);
            int index = local.index();
            if (oldIndex == index) continue;
            swaps.put(oldIndex, index);
        }
        return swaps.isEmpty() ? null : swaps;
    }

    private LocalVarRearrangement() {
    }

    public record IndexedType(Type type, int index) {
        public static IndexedType fromLocalVar(LocalVariableNode local) {
            return new IndexedType(Type.getType((String)local.desc), local.index);
        }
    }
}

