/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import umpaz.brewinandchewin.common.access.LootParamsParamSetAccess;
import umpaz.brewinandchewin.common.mixin.LootContextAccessor;
import umpaz.brewinandchewin.common.mixin.LootParamsAccessor;
import umpaz.brewinandchewin.common.registry.BnCLootConditions;

public class AreaLocationCheckCondition
implements LootItemCondition {
    private final LootItemCondition[] predicates;
    private final int range;

    protected AreaLocationCheckCondition(LootItemCondition[] predicates, int range) {
        this.predicates = predicates;
        this.range = range;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)BnCLootConditions.AREA_LOCATION_CHECK.get();
    }

    public boolean test(LootContext context) {
        Vec3 vec3 = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        for (int x = -this.range; x <= this.range; ++x) {
            for (int y = -this.range; y <= this.range; ++y) {
                for (int z = -this.range; z <= this.range; ++z) {
                    Vec3 offset = vec3.m_82520_((double)x, (double)y, (double)z);
                    LootParams.Builder paramBuilder = new LootParams.Builder(context.m_78952_());
                    LootParams originalParams = ((LootContextAccessor)context).brewinandchewin$getParams();
                    for (Map.Entry<LootContextParam<?>, Object> entry : ((LootParamsAccessor)originalParams).brewinandchewin$getParams().entrySet()) {
                        paramBuilder.m_287286_(entry.getKey(), entry.getValue());
                    }
                    paramBuilder.m_287286_(LootContextParams.f_81460_, (Object)offset);
                    if (context.m_78936_(LootContextParams.f_81461_)) {
                        paramBuilder.m_287289_(LootContextParams.f_81461_, (Object)context.m_78952_().m_8055_(BlockPos.m_274446_((Position)offset)));
                    }
                    if (context.m_78936_(LootContextParams.f_81462_)) {
                        paramBuilder.m_287289_(LootContextParams.f_81462_, (Object)context.m_78952_().m_7702_(BlockPos.m_274446_((Position)offset)));
                    }
                    LootContext newCtx = new LootContext.Builder(paramBuilder.m_287235_(((LootParamsParamSetAccess)originalParams).brewinandchewin$getParamSet())).m_287259_(null);
                    if (!Arrays.stream(this.predicates).allMatch(condition -> condition.test((Object)newCtx))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public void m_6169_(ValidationContext pContext) {
        super.m_6169_(pContext);
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i].m_6169_(pContext.m_79365_(".term[" + i + "]"));
        }
    }

    public static LootItemCondition.Builder checkArea(int range, LootItemCondition.Builder ... predicateBuilder) {
        return () -> new AreaLocationCheckCondition((LootItemCondition[])Arrays.stream(predicateBuilder).map(LootItemCondition.Builder::m_6409_).toArray(LootItemCondition[]::new), range);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<AreaLocationCheckCondition> {
        public void serialize(JsonObject json, AreaLocationCheckCondition areaLocationCheck, JsonSerializationContext context) {
            json.add("predicate", context.serialize((Object)areaLocationCheck.predicates));
            json.addProperty("range", (Number)areaLocationCheck.range);
        }

        public AreaLocationCheckCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            LootItemCondition[] predicate = (LootItemCondition[])GsonHelper.m_13836_((JsonObject)json, (String)"predicate", (JsonDeserializationContext)context, LootItemCondition[].class);
            int range = GsonHelper.m_13824_((JsonObject)json, (String)"range", (int)0);
            return new AreaLocationCheckCondition(predicate, range);
        }
    }
}

