/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.config;

import io.ejekta.bountiful.Bountiful;
import io.ejekta.bountiful.config.BountifulIO;
import io.ejekta.bountiful.config.JsonFormats;
import io.ejekta.bountiful.data.IMerge;
import io.ejekta.bountiful.data.Pool;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0007\u0018\u0000 2*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\u00020\u0003:\u00012B;\u0012\u0006\u0010/\u001a\u00020\f\u0012\u0006\u0010*\u001a\u00020\f\u0012\u0006\u0010\"\u001a\u00020!\u0012\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000$\u0012\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000'\u00a2\u0006\u0004\b0\u00101J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b \u0010\u0006R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010+\u00a8\u00063"}, d2={"Lio/ejekta/bountiful/config/ResourceLoadStrategy;", "Lio/ejekta/bountiful/data/IMerge;", "T", "", "", "clearDestination", "()V", "data", "completeLoadOf", "(Lio/ejekta/bountiful/data/IMerge;)V", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "", "fileText", "newId", "decode", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;Ljava/lang/String;)Lio/ejekta/bountiful/data/IMerge;", "id", "Ljava/io/File;", "getConfigFile", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/io/File;", "Lnet/minecraft/server/packs/resources/ResourceManager;", "manager", "", "getResources", "(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/List;", "loadData", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "loadFile", "(Lnet/minecraft/resources/ResourceLocation;)Lio/ejekta/bountiful/data/IMerge;", "loadResource", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/packs/resources/ResourceManager;)Lio/ejekta/bountiful/data/IMerge;", "loadUnloadedFiles", "Ljava/nio/file/Path;", "configPath", "Ljava/nio/file/Path;", "Lkotlinx/serialization/DeserializationStrategy;", "decoder", "Lkotlinx/serialization/DeserializationStrategy;", "", "destination", "Ljava/util/List;", "folderName", "Ljava/lang/String;", "", "loadedLocations", "Ljava/util/Set;", "strategyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Lkotlinx/serialization/DeserializationStrategy;Ljava/util/List;)V", "Companion", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nResourceLoadStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLoadStrategy.kt\nio/ejekta/bountiful/config/ResourceLoadStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n1477#2:162\n1502#2,3:163\n1505#2,3:173\n1603#2,9:176\n1855#2:185\n1856#2:187\n1612#2:188\n766#2:189\n857#2,2:190\n2661#2,7:192\n1549#2:202\n1620#2,3:203\n1747#2,3:206\n361#3,7:166\n515#3:199\n500#3,2:200\n502#3,4:209\n1#4:186\n13579#5,2:213\n*S KotlinDebug\n*F\n+ 1 ResourceLoadStrategy.kt\nio/ejekta/bountiful/config/ResourceLoadStrategy\n*L\n50#1:162\n50#1:163,3\n50#1:173,3\n77#1:176,9\n77#1:185\n77#1:187\n77#1:188\n79#1:189\n79#1:190,2\n85#1:192,7\n108#1:202\n108#1:203,3\n112#1:206,3\n50#1:166,7\n105#1:199\n105#1:200,2\n105#1:209,4\n77#1:186\n133#1:213,2\n*E\n"})
public final class ResourceLoadStrategy<T extends IMerge<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String strategyName;
    @NotNull
    private final String folderName;
    @NotNull
    private final Path configPath;
    @NotNull
    private final DeserializationStrategy<T> decoder;
    @NotNull
    private final List<T> destination;
    @NotNull
    private final Set<String> loadedLocations;

    public ResourceLoadStrategy(@NotNull String strategyName, @NotNull String folderName, @NotNull Path configPath, @NotNull DeserializationStrategy<? extends T> decoder, @NotNull List<T> destination) {
        Intrinsics.checkNotNullParameter((Object)strategyName, (String)"strategyName");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        this.strategyName = strategyName;
        this.folderName = folderName;
        this.configPath = configPath;
        this.decoder = decoder;
        this.destination = destination;
        this.loadedLocations = new LinkedHashSet();
    }

    private final T decode(ResourceLocation identifier, String fileText, String newId) {
        Object object;
        try {
            object = JsonFormats.INSTANCE.getHand().decodeFromString(this.decoder, fileText);
            IMerge $this$decode_u24lambda_u240 = (IMerge)object;
            boolean bl = false;
            $this$decode_u24lambda_u240.setId(newId);
            if ($this$decode_u24lambda_u240 instanceof Pool) {
                ((Pool)$this$decode_u24lambda_u240).setup(newId);
            }
            object = (IMerge)object;
        }
        catch (Exception e) {
            System.out.println((Object)("Could not decode file with " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ", given id '" + newId + "' in folder '" + this.folderName + "' on id " + identifier));
            e.printStackTrace();
            object = null;
        }
        return (T)object;
    }

    private final File getConfigFile(ResourceLocation id) {
        String fileName = ResourceLoadStrategy.Companion.fileName(id) + ".json";
        return new File(this.configPath.toFile(), fileName);
    }

    private final void completeLoadOf(T data) {
        this.destination.add(data);
        ((Collection)this.loadedLocations).add(data.getId());
    }

    /*
     * WARNING - void declaration
     */
    public final void loadData(@NotNull ResourceManager manager) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Iterable $this$groupBy$iv = this.getResources(manager);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ResourceLocation it = (ResourceLocation)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = ResourceLoadStrategy.Companion.fileName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map resourceMap = destination$iv$iv;
        for (Map.Entry entry : resourceMap.entrySet()) {
            Object object;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            String itemId = (String)entry.getKey();
            List resources = (List)entry.getValue();
            Bountiful.Companion.getLOGGER().debug("Querying " + this.strategyName + ": " + itemId + ", " + resources);
            ResourceLocation referenceId = (ResourceLocation)CollectionsKt.first((List)resources);
            File matchingFile = this.getConfigFile(referenceId);
            IMerge configData = null;
            if (matchingFile.exists() && (configData = (IMerge)this.loadFile(referenceId)) != null && configData.getReplace()) {
                this.completeLoadOf(configData);
                Bountiful.Companion.getLOGGER().debug("Config REPLACES so we are done here");
                continue;
            }
            Iterable $this$mapNotNull$iv = resources;
            boolean $i$f$mapNotNull = false;
            Iterable $this$getOrPut$iv$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                T it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ResourceLocation it = (ResourceLocation)element$iv$iv;
                boolean bl3 = false;
                if (this.loadResource(it, manager) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IMerge it = (IMerge)element$iv$iv;
                boolean bl = false;
                if (!it.getCanLoad()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Object object2 = (List)destination$iv$iv2;
            List it = object2;
            boolean bl = false;
            Object items = !((Collection)it).isEmpty() ? object2 : null;
            if (items == null) continue;
            Iterable $this$reduce$iv = (Iterable)items;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                $this$forEach$iv$iv$iv = (IMerge)iterator$iv.next();
                IMerge a = (IMerge)accumulator$iv;
                boolean bl5 = false;
                accumulator$iv = a.merged(b);
            }
            object2 = (IMerge)accumulator$iv;
            if (object2 == null) continue;
            Object it2 = object = object2;
            boolean bl6 = false;
            it2.finishMergedSetup();
            if (configData != null) {
                IMerge mergedWithConfig = it2.merged(configData);
                this.completeLoadOf(mergedWithConfig);
                continue;
            }
            this.completeLoadOf(it2);
        }
        this.loadUnloadedFiles();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceLocation> getResources(ResourceManager manager) {
        void $this$filterTo$iv$iv;
        Map map = manager.m_214159_(this.folderName, ResourceLoadStrategy::getResources$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"manager.findResources(fo\u2026dsWith(\".json\")\n        }");
        Map $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean regexes;
            boolean bl;
            Map.Entry element$iv$iv;
            block5: {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                String string = ((ResourceLocation)it.getKey()).m_135815_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.key.path");
                String str = StringsKt.substringBefore$default((String)string, (String)".json", null, (int)2, null);
                String idreg = "([A-Za-z_/]+)";
                Iterable $this$map$iv = BountifulIO.INSTANCE.getConfigData().getDataPackExclusions();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void exc;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    CharSequence charSequence = (CharSequence)exc;
                    collection.add(new Regex(new Regex("[*]").replace(charSequence, idreg)));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex regex = (Regex)element$iv;
                        boolean bl4 = false;
                        if (!regex.matches((CharSequence)str)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!(regexes = !bl)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    private final T loadFile(ResourceLocation id) {
        File file = this.getConfigFile(id);
        String fileContent = FilesKt.readText$default((File)file, null, (int)1, null);
        return this.decode(id, fileContent, FilesKt.getNameWithoutExtension((File)file));
    }

    private final T loadResource(ResourceLocation id, ResourceManager manager) {
        String resourceContent = ResourceLoadStrategy.Companion.read(manager, id);
        return this.decode(id, resourceContent, ResourceLoadStrategy.Companion.fileName(id));
    }

    private final void loadUnloadedFiles() {
        block1: {
            Bountiful.Companion.getLOGGER().info("Trying to load unloaded files from: " + this.configPath);
            File[] fileArray = this.configPath.toFile().listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                T it;
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (this.loadedLocations.contains(FilesKt.getNameWithoutExtension((File)file)) || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"json")) continue;
                String resourceName = StringsKt.replace$default((String)((Object)this.configPath).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null) + "/" + FilesKt.getNameWithoutExtension((File)file);
                ResourceLocation fileId = Bountiful.Companion.id(resourceName);
                T item = this.loadFile(fileId);
                if (item == null) continue;
                boolean bl2 = false;
                System.out.println((Object)("Completing load of " + it + " from " + fileId));
                this.completeLoadOf(it);
            }
        }
    }

    public final void clearDestination() {
        this.loadedLocations.clear();
        this.destination.clear();
    }

    private static final boolean getResources$lambda$7(ResourceLocation it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
        return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0004\u001a\u00020\u0003*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\b\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lio/ejekta/bountiful/config/ResourceLoadStrategy$Companion;", "", "Lnet/minecraft/resources/ResourceLocation;", "", "fileName", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/String;", "Lnet/minecraft/server/packs/resources/ResourceManager;", "id", "read", "(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/String;", "<init>", "()V", "Bountiful"})
    public static final class Companion {
        private Companion() {
        }

        private final String read(ResourceManager $this$read, ResourceLocation id) {
            InputStream inputStream = ((Resource)$this$read.m_213713_(id).get()).m_215507_();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getResource(id).get().inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            return TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset));
        }

        private final String fileName(ResourceLocation $this$fileName) {
            String string = $this$fileName.m_135815_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            return StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null), (String)".", null, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

