/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.types.builtin;

import io.ejekta.bountiful.bounty.BountyData;
import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.BountyInfo;
import io.ejekta.bountiful.bounty.types.IBountyObjective;
import io.ejekta.bountiful.bounty.types.Progress;
import io.ejekta.bountiful.data.PoolEntry;
import io.ejekta.bountiful.util.ExtMiscKt;
import io.ejekta.kambrik.ext.ExtRegIdKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b \u0010!J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity;", "Lio/ejekta/bountiful/bounty/types/IBountyObjective;", "Lnet/minecraft/server/level/ServerPlayer;", "playerEntity", "Lnet/minecraft/world/entity/LivingEntity;", "killedEntity", "", "incrementEntityBounties", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/LivingEntity;)V", "Lio/ejekta/bountiful/data/PoolEntry;", "entry", "Lnet/minecraft/server/MinecraftServer;", "server", "", "isValid", "(Lio/ejekta/bountiful/data/PoolEntry;Lnet/minecraft/server/MinecraftServer;)Z", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "Lnet/minecraft/network/chat/Component;", "textBoard", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;Lnet/minecraft/world/entity/player/Player;)Ljava/util/List;", "isObj", "Lnet/minecraft/network/chat/MutableComponent;", "textSummary", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;ZLnet/minecraft/world/entity/player/Player;)Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "<init>", "()V", "Companion", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nBountyTypeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BountyTypeEntity.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n766#2:81\n857#2,2:82\n*S KotlinDebug\n*F\n+ 1 BountyTypeEntity.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity\n*L\n52#1:81\n52#1:82,2\n*E\n"})
public final class BountyTypeEntity
implements IBountyObjective {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation id = new ResourceLocation("entity");

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public boolean isValid(@NotNull PoolEntry entry, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ResourceLocation id = ExtRegIdKt.getIdentifier(Companion.getEntityType(new ResourceLocation(entry.getContent())));
        return Intrinsics.areEqual((Object)id, (Object)new ResourceLocation(entry.getContent()));
    }

    @Override
    @NotNull
    public MutableComponent textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        boolean bl = isObj;
        if (!bl) {
            if (!bl) {
                throw new IllegalStateException(("Cannot have an entity (" + entry.getContent() + ") as a reward.").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        MutableComponent mutableComponent = Component.m_237113_((String)"Kill ").m_7220_((Component)Companion.getEntityType(entry).m_20676_().m_6881_()).m_130940_(progress.getColor()).m_7220_((Component)this.colored((Component)progress.getNeededText(), ChatFormatting.WHITE));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(\"Kill \").append(\u2026ting.WHITE)\n            )");
        return mutableComponent;
    }

    @Override
    @NotNull
    public List<Component> textBoard(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return CollectionsKt.listOf((Object)Companion.getEntityType(entry).m_20676_());
    }

    public final void incrementEntityBounties(@NotNull ServerPlayer playerEntity, @NotNull LivingEntity killedEntity) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)killedEntity, (String)"killedEntity");
        ExtMiscKt.iterateBountyStacks(playerEntity, (Function1<? super ItemStack, Unit>)((Function1)arg_0 -> BountyTypeEntity.incrementEntityBounties$lambda$1(killedEntity, playerEntity, this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit incrementEntityBounties$lambda$1(LivingEntity $killedEntity, ServerPlayer $playerEntity, BountyTypeEntity this$0, ItemStack $this$iterateBountyStacks) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$killedEntity, (String)"$killedEntity");
        Intrinsics.checkNotNullParameter((Object)$playerEntity, (String)"$playerEntity");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$iterateBountyStacks, (String)"$this$iterateBountyStacks");
        BountyInfo info = (BountyInfo)BountyInfo.Companion.get($this$iterateBountyStacks);
        BountyData data = (BountyData)BountyData.Companion.get($this$iterateBountyStacks);
        Iterable $this$filter$iv = data.getObjectives();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BountyDataEntry it = (BountyDataEntry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getLogicId(), (Object)this$0.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entityObjs = (List)destination$iv$iv;
        if (!((Collection)entityObjs).isEmpty()) {
            boolean changes = false;
            for (BountyDataEntry obj : entityObjs) {
                String string = obj.getContent();
                EntityType entityType = $killedEntity.m_6095_();
                Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"killedEntity.type");
                if (!Intrinsics.areEqual((Object)string, (Object)ExtRegIdKt.getIdentifier((EntityType)entityType).toString())) continue;
                obj.setCurrent(obj.getCurrent() + 1);
                changes = true;
            }
            if (changes) {
                BountyData.Companion.set($this$iterateBountyStacks, data);
                data.checkForCompletionAndAlert((Player)$playerEntity, $this$iterateBountyStacks);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\f"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity$Companion;", "", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "entry", "Lnet/minecraft/world/entity/EntityType;", "getEntityType", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;)Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/resources/ResourceLocation;", "id", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/world/entity/EntityType;", "<init>", "()V", "Bountiful"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityType<?> getEntityType(@NotNull BountyDataEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return this.getEntityType(new ResourceLocation(entry.getContent()));
        }

        @NotNull
        public final EntityType<?> getEntityType(@NotNull ResourceLocation id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Object object = BuiltInRegistries.f_256780_.m_7745_(id);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ENTITY_TYPE.get(id)");
            return (EntityType)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

