/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.export;

import forge.com.hollingsworth.schematic.export.CameraSettings;
import forge.com.hollingsworth.schematic.export.LytPoint;
import forge.com.hollingsworth.schematic.export.LytRect;
import forge.com.hollingsworth.schematic.export.level.GuidebookLevel;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Scene {
    private final GuidebookLevel level;
    private final CameraSettings cameraSettings;
    private int width;
    private int height;

    public Scene(GuidebookLevel level, CameraSettings cameraSettings) {
        this.level = level;
        this.cameraSettings = cameraSettings;
    }

    public Vector4f getScreenBounds() {
        float offx = this.cameraSettings.getOffsetX();
        float offy = this.cameraSettings.getOffsetY();
        this.cameraSettings.setOffsetX(0.0f);
        this.cameraSettings.setOffsetY(0.0f);
        Matrix4f viewMatrix = this.cameraSettings.getViewMatrix();
        this.cameraSettings.setOffsetX(offx);
        this.cameraSettings.setOffsetY(offy);
        Bounds result = this.getBounds(viewMatrix);
        return new Vector4f(result.min().x, result.min().y, result.max().x, result.max().y);
    }

    public void centerScene() {
        Vector4f bounds = this.getScreenBounds();
        float w = -(bounds.z - bounds.x) / 2.0f;
        float h = -(bounds.w - bounds.y) / 2.0f;
        this.cameraSettings.setOffsetX(w - bounds.x);
        this.cameraSettings.setOffsetY(h - bounds.y);
    }

    @NotNull
    private Bounds getBounds(Matrix4f viewMatrix) {
        if (!this.level.hasFilledBlocks()) {
            return new Bounds(new Vector3f(), new Vector3f());
        }
        Vector3f tmpPos = new Vector3f();
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.level.getFilledBlocks().forEach(pos -> {
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        viewMatrix.transformPosition((float)(pos.m_123341_() + xCorner), (float)(pos.m_123342_() + yCorner), (float)(pos.m_123343_() + zCorner), tmpPos);
                        min.min((Vector3fc)tmpPos);
                        max.max((Vector3fc)tmpPos);
                    }
                }
            }
        });
        return new Bounds(min, max);
    }

    public Vector2f worldToScreen(float x, float y, float z) {
        Matrix4f viewMatrix = this.cameraSettings.getViewMatrix();
        Matrix4f projectionMatrix = this.cameraSettings.getProjectionMatrix();
        Vector3f screenPos = new Vector3f();
        viewMatrix.transformPosition(x, y, z, screenPos);
        projectionMatrix.transformProject(screenPos);
        return new Vector2f(screenPos.x, screenPos.y);
    }

    private static Vector2f worldToScreen(Matrix4f viewMatrix, Matrix4f projectionMatrix, float x, float y, float z) {
        Vector3f screenPos = new Vector3f();
        viewMatrix.transformPosition(x, y, z, screenPos);
        projectionMatrix.transformProject(screenPos);
        return new Vector2f();
    }

    private void buildPickRay(float screenX, float screenY, Vector3f rayOrigin, Vector3f rayDir) {
        Matrix4f viewProj = new Matrix4f((Matrix4fc)this.cameraSettings.getProjectionMatrix());
        viewProj.mul((Matrix4fc)this.cameraSettings.getViewMatrix());
        viewProj.unprojectRay(screenX, screenY, new int[]{-1, -1, 2, 2}, rayOrigin, rayDir);
    }

    public Stream<BlockPos> getFilledBlocks() {
        return this.level.getFilledBlocks();
    }

    public Vector3fc getWorldCenter() {
        Vector3f tmpPos = new Vector3f();
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.level.getFilledBlocks().forEach(pos -> {
            Vector3f tmp = new Vector3f();
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        tmp.set((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                        min.min((Vector3fc)tmp);
                        max.max((Vector3fc)tmp);
                        tmp.add(1.0f, 1.0f, 1.0f);
                        min.min((Vector3fc)tmp);
                        max.max((Vector3fc)tmp);
                    }
                }
            }
        });
        Vector3f avg = new Vector3f((Vector3fc)min);
        avg.add((Vector3fc)max);
        avg.div(2.0f);
        return avg;
    }

    public GuidebookLevel getLevel() {
        return this.level;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public Vector2f documentToScreen(LytRect viewport, LytPoint documentPoint) {
        float localX = (documentPoint.x() - (float)viewport.x()) / (float)viewport.width() * 2.0f - 1.0f;
        float localY = -((documentPoint.y() - (float)viewport.y()) / (float)viewport.height() * 2.0f - 1.0f);
        return new Vector2f(localX, localY);
    }

    public LytPoint screenToDocument(Vector2f screen, LytRect viewport) {
        float x = (float)viewport.x() + (screen.x + 1.0f) / 2.0f * (float)viewport.width();
        float y = (float)viewport.y() + (-screen.y + 1.0f) / 2.0f * (float)viewport.height();
        return new LytPoint(x, y);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private record Bounds(Vector3f min, Vector3f max) {
    }
}

