/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.common.util;

import forge.com.hollingsworth.schematic.Constants;
import forge.com.hollingsworth.schematic.platform.Services;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SchematicExport {
    public static final Path SCHEMATICS = Services.PLATFORM.getGameDirectory().resolve("schematics");

    public static StructureTemplate getStructure(Level level, BlockPos first, BlockPos second) {
        BoundingBox bb = BoundingBox.m_162375_((Vec3i)first, (Vec3i)second);
        BlockPos origin = new BlockPos(bb.m_162395_(), bb.m_162396_(), bb.m_162398_());
        BlockPos bounds = new BlockPos(bb.m_71056_(), bb.m_71057_(), bb.m_71058_());
        StructureTemplate structure = new StructureTemplate();
        structure.m_163802_(level, origin, (Vec3i)bounds, true, Blocks.f_50016_);
        return structure;
    }

    @Nullable
    public static SchematicExportResult saveSchematic(Path dir, String fileName, boolean overwrite, StructureTemplate structure, BlockPos start, BlockPos end) {
        BoundingBox bb = BoundingBox.m_162375_((Vec3i)start, (Vec3i)end);
        BlockPos origin = new BlockPos(bb.m_162395_(), bb.m_162396_(), bb.m_162398_());
        BlockPos bounds = new BlockPos(bb.m_71056_(), bb.m_71057_(), bb.m_71058_());
        CompoundTag data = structure.m_74618_(new CompoundTag());
        String air = "minecraft:air";
        String structureVoid = "minecraft:structure_void";
        data.m_128437_("palette", 10).forEach(inbt -> {
            CompoundTag c = (CompoundTag)inbt;
            if (c.m_128441_("Name") && c.m_128461_("Name").equals(structureVoid)) {
                c.m_128359_("Name", air);
            }
        });
        if (Constants.isCreateLoaded) {
            Services.PLATFORM.appendCreateGlue((Level)Minecraft.m_91087_().f_91073_, new AABB(origin, origin.m_121955_((Vec3i)bounds)), data);
        }
        if (((String)fileName).isEmpty()) {
            fileName = "failed_fallback";
        }
        if (!overwrite) {
            fileName = SchematicExport.findFirstValidFilename((String)fileName, dir, "nbt");
        }
        if (!((String)fileName).endsWith(".nbt")) {
            fileName = (String)fileName + ".nbt";
        }
        Path file = dir.resolve((String)fileName).toAbsolutePath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            boolean overwritten = Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                NbtIo.m_128947_((CompoundTag)data, (OutputStream)out);
            }
            return new SchematicExportResult(file, dir, (String)fileName, overwritten);
        }
        catch (IOException e) {
            System.out.println("An error occurred while saving schematic [" + (String)fileName + "]");
            return null;
        }
    }

    public static String findFirstValidFilename(String name, Path folderPath, String extension) {
        String filename;
        Path filepath;
        int index = 0;
        do {
            filename = SchematicExport.slug(name) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(filepath = folderPath.resolve(filename), new LinkOption[0]));
        return filename;
    }

    public static String slug(String name) {
        return name.toLowerCase(Locale.ROOT).replaceAll("\\W+", "_");
    }

    public record SchematicExportResult(Path file, Path dir, String fileName, boolean overwritten) {
    }
}

