/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.common.util;

import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;

public class BlockUtil {
    private static final int MAX_DEPTH = 50;

    public static Iterable<BlockPos> iterateAABB(@Nullable AABB pAabb) {
        if (pAabb == null) {
            return List.of();
        }
        return BlockPos.m_121976_((int)Mth.m_14107_((double)pAabb.f_82288_), (int)Mth.m_14107_((double)pAabb.f_82289_), (int)Mth.m_14107_((double)pAabb.f_82290_), (int)Mth.m_14107_((double)pAabb.f_82291_), (int)Mth.m_14107_((double)pAabb.f_82292_), (int)Mth.m_14107_((double)pAabb.f_82293_));
    }

    public static BlockPos findAround(Level world, BlockPos start, int verticalRange, int horizontalRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        if (predicate.test((BlockGetter)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.m_7918_(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (BlockUtil.isInWorldHeight(start.m_123342_() + (y += (y_offset *= -1)), world)) continue;
            return null;
        }
        return null;
    }

    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return BlockUtil.isChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.m_7726_() instanceof ServerChunkCache) {
            ChunkHolder holder = (ChunkHolder)((ServerChunkCache)world.m_7726_()).f_8325_.f_140130_.get(ChunkPos.m_45589_((int)x, (int)z));
            if (holder != null) {
                return holder.m_140082_().getNow(ChunkHolder.f_139997_).left().isPresent();
            }
            return false;
        }
        return world.m_6522_(x, z, ChunkStatus.f_62326_, false) != null;
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return BlockUtil.isChunkLoaded(world, pos.f_45578_, pos.f_45579_);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return BlockUtil.isEntityChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return BlockUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return BlockUtil.isChunkLoaded(world, pos) && ((ServerLevel)world).m_143340_(pos.m_45615_());
        }
        return BlockUtil.isChunkLoaded(world, pos);
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.f_63865_() + dimensionType.f_156647_();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.f_156647_();
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.m_6042_();
        return yBlock > BlockUtil.getDimensionMinHeight(dimensionType) && yBlock < BlockUtil.getDimensionMaxHeight(dimensionType);
    }

    public static double boxDistance(AABB box1, AABB box2) {
        double x = Math.max(0.0, Math.max(box1.f_82288_ - box2.f_82291_, box2.f_82288_ - box1.f_82291_));
        double y = Math.max(0.0, Math.max(box1.f_82289_ - box2.f_82292_, box2.f_82289_ - box1.f_82292_));
        double z = Math.max(0.0, Math.max(box1.f_82290_ - box2.f_82293_, box2.f_82290_ - box1.f_82293_));
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double distanceBetween(BlockPos blockPos, BlockPos blockPos2) {
        return Math.sqrt(Math.pow(blockPos.m_123341_() - blockPos2.m_123341_(), 2.0) + Math.pow(blockPos.m_123342_() - blockPos2.m_123342_(), 2.0) + Math.pow(blockPos.m_123343_() - blockPos2.m_123343_(), 2.0));
    }
}

