/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import forge.com.hollingsworth.schematic.client.RaycastHelper;
import forge.com.hollingsworth.schematic.client.renderer.DireBufferBuilder;
import forge.com.hollingsworth.schematic.client.renderer.DireRenderMethods;
import forge.com.hollingsworth.schematic.client.renderer.DireRenderTypes;
import forge.com.hollingsworth.schematic.client.renderer.DireVertexConsumer;
import forge.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import forge.com.hollingsworth.schematic.client.renderer.RenderFluidBlock;
import forge.com.hollingsworth.schematic.client.renderer.StatePos;
import forge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import forge.com.hollingsworth.schematic.common.util.Color;
import forge.com.hollingsworth.schematic.common.util.DimPos;
import forge.com.hollingsworth.schematic.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class StructureRenderer {
    public static ArrayList<StructureRenderData> structures = new ArrayList();
    private static int sortCounter = 0;
    private static final Map<RenderType, DireBufferBuilder> builders = RenderType.m_110506_().stream().collect(Collectors.toMap(renderType -> renderType, type -> new DireBufferBuilder(type.m_110507_())));
    private static final Map<RenderType, VertexBuffer> vertexBuffers = RenderType.m_110506_().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));

    public static DireBufferBuilder getBuffer(RenderType renderType) {
        DireBufferBuilder buffer = builders.get(renderType);
        if (!buffer.m_85732_()) {
            buffer.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        }
        return buffer;
    }

    public static void buildRender(StructureRenderData data, PoseStack poseStack, Player player) {
        BlockPos renderPos;
        BlockHitResult lookingAt = RaycastHelper.getLookingAt(player, true);
        BlockPos blockPos = renderPos = data.anchorPos == null ? lookingAt.m_82425_() : data.anchorPos;
        if (renderPos == null) {
            return;
        }
        renderPos = renderPos.m_7494_();
        DimPos boundTo = new DimPos((ResourceKey<Level>)player.f_19853_.m_46472_(), renderPos);
        if (boundTo != null && boundTo.levelKey().equals((Object)player.m_9236_().m_46472_())) {
            StructureRenderer.drawBoundBox(data, poseStack, boundTo.pos());
        }
        renderPos = renderPos.m_7494_();
        if (StructureRenderer.shouldUpdateRender(player)) {
            StructureRenderer.generateRender(data, player.m_9236_(), renderPos, 0.5f, data.statePosCache, vertexBuffers);
            data.updateRender = false;
        }
    }

    public static boolean shouldUpdateRender(Player player) {
        return true;
    }

    public static void generateRender(StructureRenderData data, Level level, BlockPos renderPos, float transparency, ArrayList<StatePos> statePosCache, Map<RenderType, VertexBuffer> vertexBuffers) {
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        data.fakeRenderingWorld = new FakeRenderingWorld(level, statePosCache, renderPos);
        PoseStack matrix = new PoseStack();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer modelBlockRenderer = dispatcher.m_110937_();
        RandomSource random = RandomSource.m_216327_();
        for (StatePos pos2 : statePosCache.stream().filter(pos -> StructureRenderer.isModelRender(pos.state) || !pos.state.m_60819_().m_76178_()).toList()) {
            BlockState renderState = data.fakeRenderingWorld.getBlockStateWithoutReal(pos2.pos);
            if (renderState.m_60795_()) continue;
            BakedModel ibakedmodel = dispatcher.m_110910_(renderState);
            matrix.m_85836_();
            matrix.m_252880_((float)pos2.pos.m_123341_(), (float)pos2.pos.m_123342_(), (float)pos2.pos.m_123343_());
            for (RenderType renderType : Services.PLATFORM.getRenderTypes(ibakedmodel, renderState, random)) {
                if (renderType.equals(RenderType.m_110463_()) && renderState.m_60808_((BlockGetter)level, pos2.pos.m_121955_((Vec3i)renderPos)).equals(Shapes.m_83144_())) {
                    renderType = RenderType.m_110466_();
                }
                DireVertexConsumer direVertexConsumer = new DireVertexConsumer((VertexConsumer)StructureRenderer.getBuffer(renderType), transparency);
                if (renderState.m_60819_().m_76178_()) {
                    try {
                        modelBlockRenderer.m_234379_((BlockAndTintGetter)data.fakeRenderingWorld, ibakedmodel, renderState, pos2.pos.m_121955_((Vec3i)renderPos).m_6630_(255), matrix, (VertexConsumer)direVertexConsumer, false, random, renderState.m_60726_(pos2.pos.m_121955_((Vec3i)renderPos)), OverlayTexture.f_118083_);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                RenderFluidBlock.renderFluidBlock(renderState, level, pos2.pos.m_121955_((Vec3i)renderPos).m_6630_(255), matrix, direVertexConsumer, true);
            }
            matrix.m_85849_();
        }
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 subtracted = projectedView.m_82492_((double)renderPos.m_123341_(), (double)renderPos.m_123342_(), (double)renderPos.m_123343_());
        Vector3f sortPos = new Vector3f((float)subtracted.f_82479_, (float)subtracted.f_82480_, (float)subtracted.f_82481_);
        for (Map.Entry<RenderType, DireBufferBuilder> entry : builders.entrySet()) {
            RenderType renderType;
            renderType = entry.getKey();
            DireBufferBuilder direBufferBuilder = StructureRenderer.getBuffer(renderType);
            direBufferBuilder.m_277127_(VertexSorting.m_276997_((Vector3f)sortPos));
            data.sortStates.put(renderType, direBufferBuilder.m_166770_());
            VertexBuffer vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(direBufferBuilder.m_231175_());
            VertexBuffer.m_85931_();
        }
    }

    public static void drawCopyBox(PoseStack matrix, BlockPos start, BlockPos end) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85836_();
        matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
        Color color = Color.GREEN;
        DireRenderMethods.renderCopy(matrix, start, end, color);
        matrix.m_85849_();
    }

    public static void drawBoundBox(StructureRenderData data, PoseStack matrix, BlockPos blockPos) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85836_();
        matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
        Color color = Color.BLUE;
        BoundingBox boundingBox = data.boundingBox;
        if (boundingBox != null) {
            BlockPos min = new BlockPos(boundingBox.m_162395_(), boundingBox.m_162396_(), boundingBox.m_162398_());
            BlockPos max = new BlockPos(boundingBox.m_162399_(), boundingBox.m_162400_(), boundingBox.m_162401_());
            min = min.m_121955_((Vec3i)blockPos);
            max = max.m_121955_((Vec3i)blockPos);
            DireRenderMethods.renderCopy(matrix, min, max, color);
        }
        matrix.m_85849_();
    }

    public static boolean isModelRender(BlockState state) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel ibakedmodel = dispatcher.m_110910_(state);
        for (Direction direction : Direction.values()) {
            if (!ibakedmodel.m_213637_(state, direction, RandomSource.m_216327_()).isEmpty()) {
                return true;
            }
            if (ibakedmodel.m_213637_(state, null, RandomSource.m_216327_()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(StructureRenderData data, PoseStack poseStack, Matrix4f projectionMatrix, Player player) {
        if (vertexBuffers == null) {
            return;
        }
        BlockPos anchorPos = data.anchorPos;
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BlockHitResult lookingAt = RaycastHelper.getLookingAt(player, true);
        BlockPos renderPos = anchorPos == null ? lookingAt.m_82425_() : anchorPos;
        BlockState lookingAtState = player.m_9236_().m_8055_(renderPos);
        if (lookingAtState.m_60795_() && anchorPos == null) {
            return;
        }
        renderPos = renderPos.m_7494_();
        if (sortCounter > 20) {
            StructureRenderer.sortAll(data, renderPos);
            sortCounter = 0;
        } else {
            ++sortCounter;
        }
        PoseStack matrix = poseStack;
        matrix.m_85836_();
        matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
        matrix.m_252880_((float)renderPos.m_123341_(), (float)renderPos.m_123342_(), (float)renderPos.m_123343_());
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.m_110451_());
        drawSet.add(RenderType.m_110463_());
        drawSet.add(RenderType.m_110457_());
        drawSet.add(RenderType.m_110466_());
        drawSet.add(RenderType.m_110503_());
        try {
            for (RenderType renderType : drawSet) {
                RenderType drawRenderType = renderType.equals(RenderType.m_110463_()) ? DireRenderTypes.RenderBlock : RenderType.m_110466_();
                VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
                if (vertexBuffer.m_166892_() == null) continue;
                drawRenderType.m_110185_();
                vertexBuffer.m_85921_();
                vertexBuffer.m_253207_(matrix.m_85850_().m_252922_(), new Matrix4f((Matrix4fc)projectionMatrix), RenderSystem.getShader());
                VertexBuffer.m_85931_();
                drawRenderType.m_110188_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrix.m_85849_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        DireRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new DireRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 0.5f);
        data.fakeRenderingWorld = new FakeRenderingWorld(player.m_9236_(), data.statePosCache, renderPos);
        for (StatePos pos2 : data.statePosCache.stream().filter(pos -> !StructureRenderer.isModelRender(pos.state)).toList()) {
            if (pos2.state.m_60795_()) continue;
            matrix.m_85836_();
            matrix.m_85837_(-projectedView.m_7096_(), -projectedView.m_7098_(), -projectedView.m_7094_());
            matrix.m_252880_((float)renderPos.m_123341_(), (float)renderPos.m_123342_(), (float)renderPos.m_123343_());
            matrix.m_252880_((float)pos2.pos.m_123341_(), (float)pos2.pos.m_123342_(), (float)pos2.pos.m_123343_());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.m_91087_().m_167982_();
            BlockEntity blockEntity = data.fakeRenderingWorld.m_7702_(pos2.pos);
            if (blockEntity != null) {
                blockEntityRenderer.m_112267_(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer);
            } else {
                DireRenderMethods.renderBETransparent(data.fakeRenderingWorld.m_8055_(pos2.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 0.5f);
            }
            matrix.m_85849_();
        }
    }

    public static void sortAll(StructureRenderData data, BlockPos lookingAt) {
        for (Map.Entry<RenderType, BufferBuilder.SortState> entry : data.sortStates.entrySet()) {
            RenderType renderType = entry.getKey();
            BufferBuilder.RenderedBuffer renderedBuffer = StructureRenderer.sort(data, lookingAt, renderType);
            VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(renderedBuffer);
            VertexBuffer.m_85931_();
        }
    }

    public static BufferBuilder.RenderedBuffer sort(StructureRenderData data, BlockPos lookingAt, RenderType renderType) {
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 subtracted = projectedView.m_82492_((double)lookingAt.m_123341_(), (double)lookingAt.m_123342_(), (double)lookingAt.m_123343_());
        Vector3f sortPos = new Vector3f((float)subtracted.f_82479_, (float)subtracted.f_82480_, (float)subtracted.f_82481_);
        DireBufferBuilder bufferBuilder = StructureRenderer.getBuffer(renderType);
        BufferBuilder.SortState sortState = data.sortStates.get(renderType);
        bufferBuilder.m_166775_(sortState);
        bufferBuilder.m_277127_(VertexSorting.m_276997_((Vector3f)sortPos));
        data.sortStates.put(renderType, bufferBuilder.m_166770_());
        return bufferBuilder.m_231175_();
    }
}

