/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import forge.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import forge.com.hollingsworth.schematic.client.renderer.StatePos;
import forge.com.hollingsworth.schematic.client.renderer.TagPos;
import forge.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureRenderData {
    public ArrayList<StatePos> statePosCache;
    public int sortCounter;
    public BoundingBox boundingBox;
    public BlockPos anchorPos;
    public Map<RenderType, BufferBuilder.SortState> sortStates = new HashMap<RenderType, BufferBuilder.SortState>();
    public String name;
    public String blockprintsId;
    public FakeRenderingWorld fakeRenderingWorld;
    public boolean updateRender;
    public StructureTemplate structureTemplate;
    public Rotation rotation;
    public Mirror mirror;

    public StructureRenderData(StructureTemplate structureTemplate, String name, String blockprintsId) {
        StructureTemplateAccessor accessor = (StructureTemplateAccessor)structureTemplate;
        List<StructureTemplate.Palette> palettes = accessor.getPalettes();
        if (palettes.isEmpty()) {
            return;
        }
        StructureTemplate.Palette palette = palettes.get(0);
        this.statePosCache = new ArrayList();
        this.structureTemplate = structureTemplate;
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            this.statePosCache.add(new StatePos(blockInfo.f_74676_(), blockInfo.f_74675_()));
        }
        this.boundingBox = structureTemplate.m_74633_(new StructurePlaceSettings(), new BlockPos(0, 0, 0));
        this.name = name;
        this.blockprintsId = blockprintsId;
        this.updateRender = true;
        this.rotation = Rotation.NONE;
        this.mirror = Mirror.NONE;
    }

    public void rotate(Rotation rotateBy) {
        this.rotation = this.rotation.m_55952_(rotateBy);
        this.statePosCache = StatePos.rotate(this.statePosCache, new ArrayList<TagPos>(), rotateBy);
        this.boundingBox = this.structureTemplate.m_74633_(new StructurePlaceSettings().m_74379_(this.rotation), new BlockPos(0, 0, 0));
    }

    public void mirror(boolean mirror) {
        this.mirror = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        this.boundingBox = this.structureTemplate.m_74633_(new StructurePlaceSettings().m_74377_(this.mirror).m_74379_(this.rotation), new BlockPos(0, 0, 0));
    }
}

