/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.com.hollingsworth.schematic.client.renderer.QuadBakingVertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class RenderFluidBlock {
    private static BakedQuad createQuad(List<Vec3> vectors, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        QuadBakingVertexConsumer.Buffered quadBaker = new QuadBakingVertexConsumer.Buffered();
        Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_());
        RenderFluidBlock.putVertex(quadBaker, normal, vectors.get((int)0).f_82479_, vectors.get((int)0).f_82480_, vectors.get((int)0).f_82481_, u1, v1, sprite, cols, face);
        RenderFluidBlock.putVertex(quadBaker, normal, vectors.get((int)1).f_82479_, vectors.get((int)1).f_82480_, vectors.get((int)1).f_82481_, u1, v2, sprite, cols, face);
        RenderFluidBlock.putVertex(quadBaker, normal, vectors.get((int)2).f_82479_, vectors.get((int)2).f_82480_, vectors.get((int)2).f_82481_, u2, v2, sprite, cols, face);
        RenderFluidBlock.putVertex(quadBaker, normal, vectors.get((int)3).f_82479_, vectors.get((int)3).f_82480_, vectors.get((int)3).f_82481_, u2, v1, sprite, cols, face);
        return quadBaker.getQuad();
    }

    private static void putVertex(QuadBakingVertexConsumer quadBaker, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float[] cols, Direction face) {
        quadBaker.m_5483_(x, y, z);
        quadBaker.m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_);
        quadBaker.m_85950_(cols[0], cols[1], cols[2], cols[3]);
        quadBaker.m_7421_(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
        quadBaker.setSprite(sprite);
        quadBaker.setDirection(face);
        quadBaker.m_5752_();
    }

    public static void renderFluidBlock(BlockState renderState, Level level, BlockPos pos, PoseStack matrixStackIn, VertexConsumer builder, boolean renderAdjacent) {
        BakedQuad quad;
        if (renderState.m_60819_().m_76178_()) {
            return;
        }
        FluidState fluidState = renderState.m_60819_();
        Fluid fluid = fluidState.m_76152_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("block/water_still"));
        int color = -1;
        if (fluid == Fluids.f_76193_) {
            color = -12618012;
        } else if (fluid == Fluids.f_76195_) {
            sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("block/lava_still"));
        }
        int brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float minU = sprite.m_118409_();
        float minV = sprite.m_118411_();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float x2 = 1.0f;
        float z2 = 1.0f;
        float height = 0.875f;
        float size = 16.0f;
        float[] cols = new float[]{r, g, b, a};
        matrixStackIn.m_85836_();
        if (renderAdjacent) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)y, (double)z2), (Object)new Vec3((double)x, (double)y, (double)z), (Object)new Vec3((double)x2, (double)y, (double)z), (Object)new Vec3((double)x2, (double)y, (double)z2)), cols, sprite, Direction.DOWN, minU, size, minV, size);
            builder.m_85995_(matrixStackIn.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, new int[]{brightness, brightness, brightness, brightness}, 0, false);
        }
        if (renderAdjacent) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z), (Object)new Vec3((double)x, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z)), cols, sprite, Direction.UP, minU, size, minV, size);
            builder.m_85995_(matrixStackIn.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, new int[]{brightness, brightness, brightness, brightness}, 0, false);
        }
        if (renderAdjacent) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x2, (double)height, (double)z), (Object)new Vec3((double)x2, (double)y, (double)z), (Object)new Vec3((double)x, (double)y, (double)z), (Object)new Vec3((double)x, (double)height, (double)z)), cols, sprite, Direction.NORTH, minU, size, minV, size);
            builder.m_85995_(matrixStackIn.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, new int[]{brightness, brightness, brightness, brightness}, 0, false);
        }
        if (renderAdjacent) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z2), (Object)new Vec3((double)x, (double)y, (double)z2), (Object)new Vec3((double)x2, (double)y, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z2)), cols, sprite, Direction.SOUTH, minU, size, minV, size);
            builder.m_85995_(matrixStackIn.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, new int[]{brightness, brightness, brightness, brightness}, 0, false);
        }
        if (renderAdjacent) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z), (Object)new Vec3((double)x, (double)y, (double)z), (Object)new Vec3((double)x, (double)y, (double)z2), (Object)new Vec3((double)x, (double)height, (double)z2)), cols, sprite, Direction.WEST, minU, size, minV, size);
            builder.m_85995_(matrixStackIn.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, new int[]{brightness, brightness, brightness, brightness}, 0, false);
        }
        if (renderAdjacent) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x2, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)y, (double)z2), (Object)new Vec3((double)x2, (double)y, (double)z), (Object)new Vec3((double)x2, (double)height, (double)z)), cols, sprite, Direction.EAST, minU, size, minV, size);
            builder.m_85995_(matrixStackIn.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, new int[]{brightness, brightness, brightness, brightness}, 0, false);
        }
        matrixStackIn.m_85849_();
    }
}

