/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.common.util.ITooltipProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public abstract class ModScreen
extends Screen {
    public int maxScale;
    public float scaleFactor;
    public int FULL_WIDTH;
    public int FULL_HEIGHT;
    public int bookLeft;
    public int bookTop;
    public int bookRight;
    public int bookBottom;

    public ModScreen(int width, int height) {
        super((Component)Component.m_237119_());
        this.FULL_HEIGHT = height;
        this.FULL_WIDTH = width;
    }

    public void m_7856_() {
        super.m_7856_();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        this.bookLeft = this.f_96543_ / 2 - this.FULL_WIDTH / 2;
        this.bookTop = this.f_96544_ / 2 - this.FULL_HEIGHT / 2;
        this.bookRight = this.f_96543_ / 2 + this.FULL_WIDTH / 2;
        this.bookBottom = this.f_96544_ / 2 + this.FULL_HEIGHT / 2;
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        PoseStack poseStack = matrixStack.m_280168_();
        poseStack.m_85836_();
        if (this.scaleFactor != 1.0f) {
            poseStack.m_85841_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(matrixStack, mouseX, mouseY, partialTicks);
        poseStack.m_85849_();
    }

    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            if (!(renderable instanceof ITooltipProvider)) continue;
            ITooltipProvider tooltipProvider = (ITooltipProvider)renderable;
            if (!GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget)) continue;
            tooltipProvider.getTooltip(tooltip);
            break;
        }
    }

    @Nullable
    public Renderable getHoveredRenderable(int mouseX, int mouseY) {
        for (Renderable renderable : this.f_169369_) {
            AbstractWidget widget;
            if (!(renderable instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable)) continue;
            return renderable;
        }
        return null;
    }

    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280163_(this.getBgTexture(), 0, 0, 0.0f, 0.0f, this.FULL_WIDTH, this.FULL_HEIGHT, this.FULL_WIDTH, this.FULL_HEIGHT);
    }

    public void drawForegroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScreenAfterScale(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        poseStack.m_85849_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.f_96541_.m_91268_().m_85385_(0, this.f_96541_.m_91390_());
    }

    public abstract ResourceLocation getBgTexture();

    public static void blitRect(PoseStack matrixStack, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, ResourceLocation texture, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float tx0 = xt / (float)tWidth;
        float ty0 = yt / (float)tHeight;
        float tx1 = tx0 + width / (float)tWidth;
        float ty1 = ty0 + height / (float)tHeight;
        float x1 = x0 + width;
        float y1 = y0 + height;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder builder = tess.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        builder.m_252986_(matrix, x0, y1, 0.0f).m_7421_(tx0, ty1).m_5752_();
        builder.m_252986_(matrix, x1, y1, 0.0f).m_7421_(tx1, ty1).m_5752_();
        builder.m_252986_(matrix, x1, y0, 0.0f).m_7421_(tx1, ty0).m_5752_();
        builder.m_252986_(matrix, x0, y0, 0.0f).m_7421_(tx0, ty0).m_5752_();
        tess.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

