/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import forge.com.hollingsworth.schematic.api.SceneExporter;
import forge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import forge.com.hollingsworth.schematic.api.blockprints.download.PreviewDownloadResult;
import forge.com.hollingsworth.schematic.client.ClientData;
import forge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import forge.com.hollingsworth.schematic.client.gui.BlockListScreen;
import forge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import forge.com.hollingsworth.schematic.client.gui.PreviewImage;
import forge.com.hollingsworth.schematic.common.util.ClientUtil;
import forge.com.hollingsworth.schematic.common.util.FileUtils;
import forge.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.lwjgl.system.MemoryUtil;

public class DownloadScreen
extends BaseSchematicScreen {
    public static final ResourceLocation PREVIEW_TEXTURE = new ResourceLocation("blockprints", "download_preview");
    DynamicTexture dynamicTexture;
    PreviewDownloadResult preview;
    Screen previousScreen;
    List<BlockListEntry> entries = new ArrayList<BlockListEntry>();
    boolean hasMissing = false;

    public DownloadScreen(Screen previousScreen, PreviewDownloadResult preview) {
        this.previousScreen = previousScreen;
        this.preview = preview;
        for (Tuple<ResourceLocation, Integer> entry : preview.downloadResponse.blockCounts) {
            ResourceLocation resourceLocation = new ResourceLocation(((ResourceLocation)entry.m_14418_()).toString());
            int count = (Integer)entry.m_14419_();
            boolean exists = BuiltInRegistries.f_256975_.m_7804_(resourceLocation);
            Block thing = (Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation);
            if (!exists) {
                this.entries.add(new BlockListEntry(resourceLocation.toString(), count));
                this.hasMissing = true;
                continue;
            }
            ItemStack renderStack = new ItemStack((ItemLike)thing);
            this.entries.add(new BlockListEntry(renderStack.m_41786_().getString(), (Integer)entry.m_14419_(), renderStack));
        }
    }

    public static LoadingScreen<PreviewDownloadResult> getTransition(String schematicId, Screen previousScreen) {
        return new LoadingScreen<PreviewDownloadResult>(() -> BlockprintsApi.getInstance().download().downloadPreview(schematicId), result -> Minecraft.m_91087_().m_91152_((Screen)new DownloadScreen(previousScreen, (PreviewDownloadResult)result)), previousScreen);
    }

    public static DynamicTexture getTexture(PreviewDownloadResult preview) throws IOException {
        byte[] previewImage = preview.image;
        ByteBuffer buffer = MemoryUtil.memAlloc((int)previewImage.length);
        buffer.put(previewImage);
        NativeImage nativeImage = NativeImage.m_85062_((ByteBuffer)buffer.flip());
        return new DynamicTexture(nativeImage);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        try {
            this.dynamicTexture = DownloadScreen.getTexture(this.preview);
            Minecraft.m_91087_().m_91097_().m_118495_(PREVIEW_TEXTURE, (AbstractTexture)this.dynamicTexture);
            this.m_142416_(new PreviewImage(this.bookLeft + 25, this.bookTop + 41, 100, 100, this.dynamicTexture, PREVIEW_TEXTURE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GuiImageButton downloadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 153, 95, 15, new ResourceLocation("blockprints", "textures/gui/button_6.png"), b -> this.startDownload(path -> {
            Minecraft.m_91087_().m_91152_(null);
            if (path != null) {
                ClientUtil.sendMessage("blockprints.download_success");
            } else {
                ClientUtil.sendMessage("blockprints.download_failed");
            }
        }));
        String fileName = SceneExporter.sanitize(this.preview.downloadResponse.structureName + "_" + this.preview.downloadResponse.id) + ".nbt";
        Path path = Paths.get("./schematics/", fileName);
        boolean alreadyDownloaded = Files.exists(path, new LinkOption[0]);
        this.m_142416_(new GuiImageButton(this.bookLeft + 25, this.bookTop + 153, 143, 15, new ResourceLocation("blockprints", "textures/gui/button_9.png"), b -> Minecraft.m_91087_().m_91152_((Screen)new BlockListScreen(this, this.entries))));
        GuiImageButton visualizeButton = new GuiImageButton(this.bookLeft + 25, this.bookTop + 153 + 16, 143, 15, new ResourceLocation("blockprints", "textures/gui/button_9.png"), b -> {
            Consumer<Path> onPath = templatePath -> {
                StructureTemplate structureTemplate = FileUtils.loadStructureTemplate((HolderGetter<Block>)Minecraft.m_91087_().f_91073_.m_246945_(Registries.f_256747_), templatePath);
                StructureTemplateAccessor accessor = (StructureTemplateAccessor)structureTemplate;
                List<StructureTemplate.Palette> palettes = accessor.getPalettes();
                if (palettes.isEmpty()) {
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"blockprints.invalid_file"));
                } else {
                    ClientData.startStructureRenderer(structureTemplate, this.preview.downloadResponse.structureName, this.preview.downloadResponse.id);
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"blockprints.start_placing", (Object[])new Object[]{ClientData.ROTATE_LEFT.m_90863_(), ClientData.ROTATE_RIGHT.m_90863_(), ClientData.CONFIRM.m_90863_(), ClientData.CANCEL.m_90863_()}));
                }
                Minecraft.m_91087_().m_91152_(null);
            };
            if (!alreadyDownloaded) {
                this.startDownload(onPath);
            } else {
                onPath.accept(path);
            }
        });
        if (alreadyDownloaded) {
            downloadButton.withTooltip((Component)Component.m_237110_((String)"blockprints.already_downloaded_tooltip", (Object[])new Object[]{"./schematics/" + fileName}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        } else {
            downloadButton.withTooltip((Component)(this.hasMissing ? Component.m_237115_((String)"blockprints.blocks_missing_tooltip").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)) : null)).withTooltip((Component)Component.m_237115_((String)"blockprints.download_tooltip"));
            visualizeButton.withTooltip((Component)Component.m_237115_((String)"blockprints.visualize_download"));
        }
        this.m_142416_(visualizeButton);
        this.m_142416_(downloadButton);
        this.m_142416_(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new ResourceLocation("blockprints", "textures/gui/button_back.png"), b -> Minecraft.m_91087_().m_91152_(this.previousScreen)));
    }

    public void startDownload(Consumer<Path> callback) {
        Minecraft.m_91087_().m_91152_(new LoadingScreen<Path>(() -> BlockprintsApi.getInstance().download().downloadSchematic(this.preview.downloadResponse.id, this.preview.downloadResponse.structureName), callback));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_download.png"), this.bookRight - 116, this.bookTop + 155, 0.0f, 0.0f, 9, 11, 9, 11);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_list.png"), this.bookLeft + 28, this.bookTop + 157, 0.0f, 0.0f, 9, 7, 9, 7);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_visualize.png"), this.bookLeft + 28, this.bookTop + 157 + 16, 0.0f, 0.0f, 9, 7, 9, 7);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.download").m_7532_(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.view_list").m_7532_(), this.bookLeft + 34 + 71, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.visualize").m_7532_(), this.bookLeft + 34 + 71, this.bookTop + 157 + 16);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_title_body.png"), 185, 25, 0.0f, 0.0f, 95, 127, 95, 127);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, (Component)Component.m_237113_((String)this.preview.downloadResponse.structureName), 96, 29);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)this.preview.downloadResponse.description), 187, 44, 95, 0);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, (Component)Component.m_237115_((String)"blockprints.description_title"), 232, 29);
    }

    public void m_7861_() {
        super.m_7861_();
        Minecraft.m_91087_().m_91097_().m_118513_(PREVIEW_TEXTURE);
    }

    public static class BlockListEntry {
        public String name;
        public int count;
        public ItemStack renderStack;
        public boolean isMissing;

        public BlockListEntry(String name, int count, ItemStack renderStack) {
            this.name = name;
            this.count = count;
            this.renderStack = renderStack;
            this.isMissing = false;
        }

        public BlockListEntry(String name, int count) {
            this(name, count, ItemStack.f_41583_);
            this.isMissing = true;
        }
    }
}

