/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import forge.com.hollingsworth.schematic.client.AreaCaptureHandler;
import forge.com.hollingsworth.schematic.client.RenderStructureHandler;
import forge.com.hollingsworth.schematic.client.gui.HomeScreen;
import forge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import forge.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.joml.Matrix4f;

public class ClientData {
    private static final String CATEGORY = "key.category.blockprints.general";
    public static final KeyMapping OPEN_MENU = new KeyMapping("key.blockprints.open_menu", 96, "key.category.blockprints.general");
    public static final KeyMapping CONFIRM = new KeyMapping("key.blockprints.confirm_selection", 257, "key.category.blockprints.general");
    public static final KeyMapping CANCEL = new KeyMapping("key.blockprints.cancel_selection", 259, "key.category.blockprints.general");
    public static final KeyMapping ROTATE_LEFT = new KeyMapping("key.blockprints.rotate_left", 263, "key.category.blockprints.general");
    public static final KeyMapping ROTATE_RIGHT = new KeyMapping("key.blockprints.rotate_right", 262, "key.category.blockprints.general");
    public static final KeyFunction[] KEY_FUNCTIONS = new KeyFunction[]{new KeyFunction(OPEN_MENU, ClientData::openMenu), new KeyFunction(CONFIRM, ClientData::onConfirmHit), new KeyFunction(CANCEL, ClientData::onCancelHit), new KeyFunction(ROTATE_LEFT, () -> ClientData.onRotateHit(false)), new KeyFunction(ROTATE_RIGHT, () -> ClientData.onRotateHit(true))};

    public static void openMenu() {
        Minecraft.m_91087_().m_91152_((Screen)new HomeScreen());
    }

    public static void startBoundaryCapture() {
        AreaCaptureHandler.startCapture();
        RenderStructureHandler.cancelRender();
    }

    public static void startStructureRenderer(StructureTemplate structureTemplate, String name, String blockprintsId) {
        RenderStructureHandler.startRender(structureTemplate, name, blockprintsId);
        AreaCaptureHandler.cancelCapture();
    }

    public static void onConfirmHit() {
        AreaCaptureHandler.onConfirmHit();
        RenderStructureHandler.onConfirmHit();
    }

    public static void onCancelHit() {
        AreaCaptureHandler.onCancelHit();
        RenderStructureHandler.onCancelHit();
    }

    public static void onRotateHit(boolean clockwise) {
        RenderStructureHandler.onRotateHit(clockwise);
    }

    public static void onMirrorHit() {
        RenderStructureHandler.onMirrorHit();
    }

    public static void renderAfterSky(PoseStack poseStack) {
        AreaCaptureHandler.renderBoundary(poseStack);
    }

    public static void renderAfterTransparentBlocks(PoseStack poseStack, Matrix4f projectionMatrix) {
        for (StructureRenderData data : StructureRenderer.structures) {
            StructureRenderer.buildRender(data, poseStack, (Player)Minecraft.m_91087_().f_91074_);
            StructureRenderer.drawRender(data, poseStack, projectionMatrix, (Player)Minecraft.m_91087_().f_91074_);
        }
    }

    public static void rightClickEvent() {
        AreaCaptureHandler.positionClicked();
        RenderStructureHandler.positionClicked();
    }

    public static void renderGUIOverlayEvent(GuiGraphics graphics, Window window) {
        AreaCaptureHandler.renderBoundaryUI(graphics, window);
        RenderStructureHandler.renderInstructions(graphics, window);
    }

    public record KeyFunction(KeyMapping mapping, Runnable function) {
    }
}

