/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.api.blockprints.favorites;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import forge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import forge.com.hollingsworth.schematic.api.blockprints.RequestUtil;
import forge.com.hollingsworth.schematic.api.blockprints.favorites.FavoritesResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class Favorites {
    private final BlockprintsApi api;
    private final HttpClient CLIENT;

    public Favorites(BlockprintsApi api) {
        this.api = api;
        this.CLIENT = this.api.CLIENT;
    }

    public ApiResponse<FavoritesResponse> getFavorites() {
        return this.getFavorites(true, true, true);
    }

    public ApiResponse<FavoritesResponse> getFavorites(boolean getFavorites, boolean getBuilds, boolean getRecents) {
        try {
            URIBuilder uriBuilder = new URIBuilder(RequestUtil.getDomain() + "/api/v1/schematics/favorites");
            uriBuilder.setParameter("favorites", String.valueOf(getFavorites)).setParameter("builds", String.valueOf(getBuilds)).setParameter("recent", String.valueOf(getRecents));
            HttpRequest request = this.api.getBuilder().uri(uriBuilder.build()).GET().build();
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            int code = res.statusCode();
            if (!RequestUtil.responseSuccessful(code)) {
                return ApiResponse.parseServerError(res);
            }
            JsonObject responseObj = JsonParser.parseString((String)res.body()).getAsJsonObject();
            return ApiResponse.success(new FavoritesResponse(responseObj));
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }

    public ApiResponse<Boolean> addFavorite(String id) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", id);
        HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/schematics/favorites")).PUT(HttpRequest.BodyPublishers.ofString(jsonObject.toString())).build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (!RequestUtil.responseSuccessful(res.statusCode())) {
                return ApiResponse.parseServerError(res);
            }
            return ApiResponse.success();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }

    public ApiResponse<Boolean> removeFavorite(String id) {
        HttpRequest request = this.api.getBuilder(false).uri(RequestUtil.getRoute("/api/v1/schematics/favorites/" + id)).DELETE().build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (!RequestUtil.responseSuccessful(res.statusCode())) {
                return ApiResponse.parseServerError(res);
            }
            return ApiResponse.success();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }
}

