/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.export;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.export.WebPExporter;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_758;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OffScreenRenderer
implements AutoCloseable {
    private final class_1011 nativeImage;
    public final class_6367 fb;
    public final int width;
    public final int height;
    private final class_1044 texture = new class_1044(){

        public int method_4624() {
            return OffScreenRenderer.this.fb.method_30277();
        }

        public void method_4625(class_3300 resourceManager) throws IOException {
        }
    };

    public OffScreenRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        this.nativeImage = new class_1011(width, height, true);
        this.fb = new class_6367(width, height, true, true);
        this.fb.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.method_1230(true);
    }

    public class_1044 getTexture() {
        return this.texture;
    }

    public void renderToTexture(Runnable r) {
        RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        int currentBuffer = GlStateManager.getBoundFramebuffer();
        this.fb.method_1235(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.method_1240();
        GlStateManager._glBindFramebuffer((int)36160, (int)currentBuffer);
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null) {
            class_1041 window = minecraft.method_22683();
            RenderSystem.viewport((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
        }
    }

    @Override
    public void close() {
        this.nativeImage.close();
        this.fb.method_1238();
    }

    public byte[] captureAsPng(Runnable r) {
        this.renderToBuffer(r);
        try {
            return this.nativeImage.method_24036();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode image as PNG", e);
        }
    }

    public void captureAsPng(Runnable r, Path path) throws IOException {
        this.renderToBuffer(r);
        this.nativeImage.method_4314(path);
    }

    public boolean isAnimated(Collection<class_1058> sprites) {
        return sprites.stream().anyMatch(s -> s.method_45851().field_40541 != null);
    }

    public byte[] captureAsWebp(Runnable r, Collection<class_1058> sprites, WebPExporter.Format format) {
        List<class_1058> animatedSprites = sprites.stream().filter(sprite -> sprite.method_45851().field_40541 != null).toList();
        if (animatedSprites.isEmpty()) {
            return this.captureAsPng(r);
        }
        int maxTime = animatedSprites.stream().mapToInt(s -> s.method_45851().field_40541.field_28472.stream().mapToInt(value -> value.field_28476).sum()).max().orElse(0);
        class_1060 textureManager = class_310.method_1551().method_1531();
        Map<class_2960, List> tickers = animatedSprites.stream().collect(Collectors.groupingBy(class_1058::method_45852)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(class_1058::method_33437).toList()));
        for (class_1058 sprite2 : animatedSprites) {
            textureManager.method_4619(sprite2.method_45852()).method_23207();
            sprite2.method_4584();
        }
        int width = this.nativeImage.method_4307();
        int height = this.nativeImage.method_4323();
        try (WebPExporter webpWriter = new WebPExporter(width, height, format);){
            for (int i = 0; i < maxTime; ++i) {
                for (Map.Entry<class_2960, List> entry : tickers.entrySet()) {
                    textureManager.method_4619(entry.getKey()).method_23207();
                    for (class_1058.class_7770 ticker : entry.getValue()) {
                        ticker.method_45853();
                    }
                }
                this.renderToBuffer(r);
                webpWriter.writeFrame(i, this.nativeImage);
            }
            byte[] byArray = webpWriter.finish();
            return byArray;
        }
    }

    private void renderToBuffer(Runnable r) {
        this.fb.method_1235(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.method_1240();
        this.fb.method_35610();
        this.nativeImage.method_4327(0, false);
        this.nativeImage.method_4319();
        this.fb.method_1242();
    }

    public void setupOrtographicRendering() {
        float angle = 36.0f;
        float renderHeight = 0.0f;
        float renderScale = 100.0f;
        float rotation = 45.0f;
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(-1.0f, 1.0f, 1.0f, -1.0f, 1000.0f, 3000.0f), (class_8251)class_8251.field_43361);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_34426();
        poseStack.method_46416(0.0f, 0.0f, -2000.0f);
        class_758.method_23792();
        poseStack.method_22905(1.0f, -1.0f, -1.0f);
        poseStack.method_22907(new Quaternionf().rotationY((float)(-Math.PI)));
        Quaternionf flip = new Quaternionf().rotationZ((float)Math.PI);
        flip.mul((Quaternionfc)new Quaternionf().rotationX((float)Math.PI / 180 * angle));
        poseStack.method_22904(0.0, (double)renderHeight / -300.0, 0.0);
        poseStack.method_22905(renderScale * 0.004f, renderScale * 0.004f, 1.0f);
        Quaternionf rotate = new Quaternionf().rotationY((float)Math.PI / 180 * rotation);
        poseStack.method_22907(flip);
        poseStack.method_22907(rotate);
        RenderSystem.applyModelViewMatrix();
        class_308.method_27869((Matrix4f)poseStack.method_23760().method_23761());
    }

    public void setupPerspectiveRendering(float zoom, float fov, Vector3f eyePos, Vector3f lookAt) {
        float aspectRatio = (float)this.width / (float)this.height;
        class_4587 projMat = new class_4587();
        if (zoom != 1.0f) {
            projMat.method_22905(zoom, zoom, 1.0f);
        }
        projMat.method_34425(new Matrix4f().perspective(fov, aspectRatio, 0.05f, 16.0f));
        RenderSystem.setProjectionMatrix((Matrix4f)projMat.method_23760().method_23761(), (class_8251)class_8251.field_43360);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_34426();
        Matrix4f vm = OffScreenRenderer.createViewMatrix(eyePos, lookAt);
        poseStack.method_34425(vm);
        RenderSystem.applyModelViewMatrix();
        class_308.method_27869((Matrix4f)poseStack.method_23760().method_23761());
    }

    private static Matrix4f createViewMatrix(Vector3f eyePos, Vector3f lookAt) {
        Vector3f dir = new Vector3f((Vector3fc)lookAt);
        dir.sub((Vector3fc)eyePos);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        dir.normalize();
        Vector3f right = new Vector3f((Vector3fc)dir);
        right.cross((Vector3fc)up);
        right.normalize();
        up = new Vector3f((Vector3fc)right);
        up.cross((Vector3fc)dir);
        up.normalize();
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.setTransposed(FloatBuffer.wrap(new float[]{right.x(), right.y(), right.z(), 0.0f, up.x(), up.y(), up.z(), 0.0f, -dir.x(), -dir.y(), -dir.z(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        viewMatrix.translate(-eyePos.x(), -eyePos.y(), -eyePos.z());
        return viewMatrix;
    }
}

