/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.export;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.export.CameraSettings;
import fabric.com.hollingsworth.schematic.export.GuidebookLightmap;
import fabric.com.hollingsworth.schematic.export.LiquidVertexConsumer;
import fabric.com.hollingsworth.schematic.export.level.GuidebookLevel;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_6854;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GuidebookLevelRenderer {
    private static GuidebookLevelRenderer instance;
    private final GuidebookLightmap lightmap = new GuidebookLightmap();

    public static GuidebookLevelRenderer getInstance() {
        RenderSystem.assertOnRenderThread();
        if (instance == null) {
            instance = new GuidebookLevelRenderer();
        }
        return instance;
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings) {
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        class_4597.class_4598 buffers = class_310.method_1551().method_22940().method_23000();
        this.render(level, cameraSettings, buffers);
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, class_4597.class_4598 buffers) {
        this.lightmap.update(level);
        class_3568 lightEngine = level.method_22336();
        while (lightEngine.method_15518()) {
            lightEngine.method_15516();
        }
        Matrix4f projectionMatrix = cameraSettings.getProjectionMatrix();
        Matrix4f viewMatrix = cameraSettings.getViewMatrix();
        RenderSystem.setShaderFogColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        RenderSystem.setShaderFogStart((float)0.0f);
        RenderSystem.setShaderFogEnd((float)1000.0f);
        RenderSystem.setShaderFogShape((class_6854)class_6854.field_36350);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34426();
        modelViewStack.method_34425(viewMatrix);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)class_8251.field_43361);
        Vector4f lightDirection = new Vector4f(0.16666667f, 0.35f, 1.0f, 0.0f);
        Matrix4f lightTransform = new Matrix4f((Matrix4fc)viewMatrix);
        lightTransform.invert();
        lightTransform.transform(lightDirection);
        Vector3f transformedLightDirection = new Vector3f(lightDirection.x, lightDirection.y, lightDirection.z);
        RenderSystem.setShaderLights((Vector3f)transformedLightDirection, (Vector3f)transformedLightDirection);
        this.renderContent(level, buffers);
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        class_308.method_24211();
    }

    public void renderContent(GuidebookLevel level, class_4597.class_4598 buffers) {
        RenderSystem.runAsFancy(() -> {
            this.renderBlocks(level, (class_4597)buffers, false);
            this.renderBlockEntities(level, (class_4597)buffers);
            buffers.method_22994(class_1921.method_23572((class_2960)class_1059.field_5275));
            buffers.method_22994(class_1921.method_23576((class_2960)class_1059.field_5275));
            buffers.method_22994(class_1921.method_23578((class_2960)class_1059.field_5275));
            buffers.method_22994(class_1921.method_23584((class_2960)class_1059.field_5275));
            for (class_1921 layer : class_1921.method_22720()) {
                if (layer == class_1921.method_23583()) continue;
                buffers.method_22994(layer);
            }
            buffers.method_22994(class_1921.method_23577());
            buffers.method_22994(class_1921.method_23574());
            buffers.method_22994(class_1921.method_34571());
            buffers.method_22994(class_4722.method_24073());
            buffers.method_22994(class_4722.method_24074());
            buffers.method_22994(class_4722.method_24069());
            buffers.method_22994(class_4722.method_24070());
            buffers.method_22994(class_4722.method_24071());
            buffers.method_22994(class_4722.method_45783());
            buffers.method_22994(class_4722.method_24072());
            buffers.method_22993();
            this.renderBlocks(level, (class_4597)buffers, true);
            buffers.method_22994(class_1921.method_23583());
        });
    }

    private void renderBlocks(GuidebookLevel level, class_4597 buffers, boolean translucent) {
        class_5819 randomSource = level.field_9229;
        class_776 blockRenderDispatcher = class_310.method_1551().method_1541();
        class_4587 poseStack = new class_4587();
        level.getFilledBlocks().forEach(pos -> {
            class_4588 bufferBuilder;
            class_1921 renderType;
            class_2680 blockState = level.method_8320((class_2338)pos);
            class_3610 fluidState = blockState.method_26227();
            if (!fluidState.method_15769() && ((renderType = class_4696.method_23680((class_3610)fluidState)) != class_1921.method_23583() || translucent)) {
                bufferBuilder = buffers.getBuffer(renderType);
                class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
                LiquidVertexConsumer liquidVertexConsumer = new LiquidVertexConsumer(bufferBuilder, sectionPos);
                blockRenderDispatcher.method_3352(pos, (class_1920)level, (class_4588)liquidVertexConsumer, blockState, fluidState);
                GuidebookLevelRenderer.markFluidSpritesActive(fluidState);
            }
            if (blockState.method_26217() != class_2464.field_11455 && ((renderType = class_4696.method_23679((class_2680)blockState)) != class_1921.method_23583() || translucent)) {
                bufferBuilder = buffers.getBuffer(renderType);
                poseStack.method_22903();
                poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                blockRenderDispatcher.method_3355(blockState, pos, (class_1920)level, poseStack, bufferBuilder, true, randomSource);
                poseStack.method_22909();
            }
        });
    }

    private void renderBlockEntities(GuidebookLevel level, class_4597 buffers) {
        class_4587 poseStack = new class_4587();
        level.getFilledBlocks().forEach(pos -> {
            class_2586 blockEntity;
            class_2680 blockState = level.method_8320((class_2338)pos);
            if (blockState.method_31709() && (blockEntity = level.method_8321((class_2338)pos)) != null) {
                this.handleBlockEntity(poseStack, blockEntity, buffers);
            }
        });
    }

    private static void markFluidSpritesActive(class_3610 fluidState) {
    }

    private <E extends class_2586> void handleBlockEntity(class_4587 stack, E blockEntity, class_4597 buffers) {
        class_824 dispatcher = class_310.method_1551().method_31975();
        class_827 renderer = dispatcher.method_3550(blockEntity);
        if (renderer != null) {
            class_2338 pos = blockEntity.method_11016();
            stack.method_22903();
            stack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            int packedLight = class_761.method_23794((class_1920)blockEntity.method_10997(), (class_2338)blockEntity.method_11016());
            try {
                renderer.method_3569(blockEntity, 0.0f, stack, buffers, packedLight, class_4608.field_21444);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stack.method_22909();
        }
    }
}

