/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.common.util;

import fabric.com.hollingsworth.schematic.Constants;
import fabric.com.hollingsworth.schematic.platform.Services;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

public class SchematicExport {
    public static final Path SCHEMATICS = Services.PLATFORM.getGameDirectory().resolve("schematics");

    public static class_3499 getStructure(class_1937 level, class_2338 first, class_2338 second) {
        class_3341 bb = class_3341.method_34390((class_2382)first, (class_2382)second);
        class_2338 origin = new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417());
        class_2338 bounds = new class_2338(bb.method_35414(), bb.method_14660(), bb.method_14663());
        class_3499 structure = new class_3499();
        structure.method_15174(level, origin, (class_2382)bounds, true, class_2246.field_10124);
        return structure;
    }

    @Nullable
    public static SchematicExportResult saveSchematic(Path dir, String fileName, boolean overwrite, class_3499 structure, class_2338 start, class_2338 end) {
        class_3341 bb = class_3341.method_34390((class_2382)start, (class_2382)end);
        class_2338 origin = new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417());
        class_2338 bounds = new class_2338(bb.method_35414(), bb.method_14660(), bb.method_14663());
        class_2487 data = structure.method_15175(new class_2487());
        String air = "minecraft:air";
        String structureVoid = "minecraft:structure_void";
        data.method_10554("palette", 10).forEach(inbt -> {
            class_2487 c = (class_2487)inbt;
            if (c.method_10545("Name") && c.method_10558("Name").equals(structureVoid)) {
                c.method_10582("Name", air);
            }
        });
        if (Constants.isCreateLoaded) {
            Services.PLATFORM.appendCreateGlue((class_1937)class_310.method_1551().field_1687, new class_238(origin, origin.method_10081((class_2382)bounds)), data);
        }
        if (((String)fileName).isEmpty()) {
            fileName = "failed_fallback";
        }
        if (!overwrite) {
            fileName = SchematicExport.findFirstValidFilename((String)fileName, dir, "nbt");
        }
        if (!((String)fileName).endsWith(".nbt")) {
            fileName = (String)fileName + ".nbt";
        }
        Path file = dir.resolve((String)fileName).toAbsolutePath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            boolean overwritten = Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                class_2507.method_10634((class_2487)data, (OutputStream)out);
            }
            return new SchematicExportResult(file, dir, (String)fileName, overwritten);
        }
        catch (IOException e) {
            System.out.println("An error occurred while saving schematic [" + (String)fileName + "]");
            return null;
        }
    }

    public static String findFirstValidFilename(String name, Path folderPath, String extension) {
        String filename;
        Path filepath;
        int index = 0;
        do {
            filename = SchematicExport.slug(name) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(filepath = folderPath.resolve(filename), new LinkOption[0]));
        return filename;
    }

    public static String slug(String name) {
        return name.toLowerCase(Locale.ROOT).replaceAll("\\W+", "_");
    }

    public record SchematicExportResult(Path file, Path dir, String fileName, boolean overwritten) {
    }
}

