/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import fabric.com.hollingsworth.schematic.api.SceneExporter;
import fabric.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import fabric.com.hollingsworth.schematic.client.gui.CheckBoxButton;
import fabric.com.hollingsworth.schematic.client.gui.GimbalButton;
import fabric.com.hollingsworth.schematic.client.gui.GuiImageButton;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import fabric.com.hollingsworth.schematic.client.gui.HomeScreen;
import fabric.com.hollingsworth.schematic.client.gui.HorizontalSlider;
import fabric.com.hollingsworth.schematic.client.gui.LoadingScreen;
import fabric.com.hollingsworth.schematic.client.gui.NoScrollMultiText;
import fabric.com.hollingsworth.schematic.client.gui.ScenePreview;
import fabric.com.hollingsworth.schematic.client.gui.ShortTextField;
import fabric.com.hollingsworth.schematic.common.util.ClientUtil;
import fabric.com.hollingsworth.schematic.export.CameraSettings;
import fabric.com.hollingsworth.schematic.export.Scene;
import fabric.com.hollingsworth.schematic.export.WrappedScene;
import fabric.com.hollingsworth.schematic.export.level.GuidebookLevel;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3499;
import net.minecraft.class_437;

public class UploadPreviewScreen
extends BaseSchematicScreen {
    ScenePreview scenePreview;
    HorizontalSlider yawSlider;
    HorizontalSlider pitchSlider;
    ShortTextField nameField;
    NoScrollMultiText descriptionField;
    GuiImageButton uploadButton;
    public class_3499 structureTemplate;
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MIN_NAME_LENGTH = 10;
    public static final int MAX_DESC_LENGTH = 1000;
    public static final int MIN_DESC_LENGTH = 20;
    public boolean makePublic = false;
    public class_2338 start;
    public class_2338 end;

    public UploadPreviewScreen(class_3499 structureTemplate, class_2338 start, class_2338 end) {
        this.structureTemplate = structureTemplate;
        this.start = start;
        this.end = end;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        WrappedScene wrappedScene = new WrappedScene();
        Scene scene = new Scene(new GuidebookLevel(), new CameraSettings());
        wrappedScene.setScene(scene);
        wrappedScene.placeStructure(this.structureTemplate);
        this.nameField = new ShortTextField(this.field_22793, this.bookLeft + 185, this.bookTop + 39, (class_2561)class_2561.method_43473());
        this.descriptionField = new NoScrollMultiText(this.field_22793, this.bookLeft + 185, this.bookTop + 71, 95, 81, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473());
        this.uploadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 169, 95, 15, new class_2960("blockprints", "textures/gui/button_6.png"), b -> {
            String name = this.nameField.method_1882().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100 || name.length() < 10 || desc.length() > 1000 || desc.length() < 20) {
                return;
            }
            SceneExporter sceneExporter = new SceneExporter(wrappedScene, this.structureTemplate);
            if (sceneExporter.scene.getSizeForExport(2.0f) == null) {
                class_310.method_1551().method_1507(null);
                ClientUtil.sendMessage((class_2561)class_2561.method_43471((String)"blockprints.invalid_upload").method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
                return;
            }
            List<WrappedScene.ImageExport> images = sceneExporter.getImages();
            class_310.method_1551().method_1507(new LoadingScreen<String>(() -> sceneExporter.writeAndUpload(images, this.nameField.method_1882(), this.descriptionField.getValue(), this.makePublic, this.start, this.end), res -> {
                class_310.method_1551().method_1507(null);
                String url = "https://blockprints.io/schematic/" + res;
                ClientUtil.sendMessage((class_2561)class_2561.method_43469((String)"blockprints.upload_complete", (Object[])new Object[]{class_2561.method_43470((String)url).method_27696(class_2583.field_24360.method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_11749, url)))}));
            }));
        });
        this.method_37063(this.uploadButton);
        this.method_37063(this.nameField);
        this.method_37063(this.descriptionField);
        this.yawSlider = new HorizontalSlider(this.bookLeft + 41, this.bookTop + 153, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), 0.0, 360.0, 225.0, 5.0, 1, false, this::setYaw);
        this.pitchSlider = new HorizontalSlider(this.bookLeft + 41, this.bookTop + 169, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), 0.0, 90.0, 30.0, 5.0, 1, true, this::setPitch);
        this.method_37063(this.yawSlider);
        this.method_37063(this.pitchSlider);
        this.scenePreview = new ScenePreview(this.bookLeft + 25, this.bookTop + 41, 100, 100, scene, wrappedScene);
        this.scenePreview.yaw = 225;
        this.scenePreview.pitch = 30;
        this.method_37063(this.scenePreview);
        this.method_37063(new GimbalButton(this.bookLeft + 155, this.bookTop + 47, "northeast", b -> {
            this.setYaw(225);
            this.setPitch(30);
        }));
        this.method_37063(new GimbalButton(this.bookLeft + 149, this.bookTop + 47, "northwest", b -> {
            this.setYaw(135);
            this.setPitch(30);
        }));
        this.method_37063(new GimbalButton(this.bookLeft + 149, this.bookTop + 53, "southwest", b -> {
            this.setYaw(45);
            this.setPitch(30);
        }));
        this.method_37063(new GimbalButton(this.bookLeft + 155, this.bookTop + 53, "southeast", b -> {
            this.setYaw(315);
            this.setPitch(30);
        }));
        this.method_37063(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new class_2960("blockprints", "textures/gui/button_back.png"), b -> class_310.method_1551().method_1507((class_437)new HomeScreen())));
        this.method_37063(new CheckBoxButton(this.bookRight - 119, this.bookTop + 153, b -> {
            this.makePublic = !this.makePublic;
        }, () -> this.makePublic).withTooltip((class_2561)class_2561.method_43471((String)"blockprints.make_public_tooltip")));
    }

    public void method_25432() {
        super.method_25432();
        this.scenePreview.removed();
    }

    public void setYaw(int yaw) {
        this.scenePreview.yaw = yaw;
        this.yawSlider.setValue(yaw);
    }

    public void setPitch(int pitch) {
        this.scenePreview.pitch = pitch;
        this.pitchSlider.setValue(pitch);
    }

    @Override
    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_upload.png"), this.bookRight - 116, this.bookTop + 171, 0.0f, 0.0f, 9, 11, 9, 11);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.make_public").method_30937(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.upload").method_30937(), this.bookRight - 67, this.bookTop + 173);
    }

    @Override
    public void collectTooltips(class_332 stack, int mouseX, int mouseY, List<class_2561> tooltip) {
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (class_339)this.uploadButton)) {
            String name = this.nameField.method_1882().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100) {
                tooltip.add((class_2561)class_2561.method_43471((String)"blockprints.name_too_long"));
            }
            if (name.length() < 10) {
                tooltip.add((class_2561)class_2561.method_43471((String)"blockprints.name_too_short"));
            }
            if (desc.length() > 1000) {
                tooltip.add((class_2561)class_2561.method_43471((String)"blockprints.description_too_long"));
            }
            if (desc.length() < 20) {
                tooltip.add((class_2561)class_2561.method_43471((String)"blockprints.description_too_short"));
            }
        }
    }

    @Override
    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/diologue_title.png"), 185, 25, 0.0f, 0.0f, 95, 14, 95, 14);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/diologue_title.png"), 185, 57, 0.0f, 0.0f, 95, 14, 95, 14);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.set_preview").method_30937(), 96, 29);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.name").method_30937(), 233, 29);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.description").method_30937(), 233, 61);
    }
}

