/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.client.gui.ModScreen;
import fabric.com.hollingsworth.schematic.export.LytSize;
import fabric.com.hollingsworth.schematic.export.OffScreenRenderer;
import fabric.com.hollingsworth.schematic.export.Scene;
import fabric.com.hollingsworth.schematic.export.WrappedScene;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class ScenePreview
extends class_339 {
    public int yaw = 225;
    public int pitch = 30;
    public int roll;
    public WrappedScene wrappedScene;
    public Scene scene;
    public OffScreenRenderer renderer;

    public ScenePreview(int x, int y, int width, int height, Scene scene, WrappedScene wrappedScene) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.wrappedScene = wrappedScene;
        this.scene = scene;
    }

    public void updateSceneTexture() {
        this.scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, this.roll);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(1.0f);
        this.scene.centerScene();
        LytSize prefSize = this.wrappedScene.getPreferredSize();
        float scale = (float)class_310.method_1551().method_22683().method_4495();
        if (prefSize.width() > 0 && prefSize.height() > 0) {
            int renderWidth = (int)Math.max(1.0f, (float)prefSize.width() * scale);
            int renderHeight = (int)Math.max(1.0f, (float)prefSize.height() * scale);
            if (this.renderer == null || this.renderer.width != renderWidth || this.renderer.height != renderHeight) {
                if (this.renderer != null) {
                    this.renderer.close();
                }
                this.renderer = new OffScreenRenderer(renderWidth, renderHeight);
            }
            this.renderer.renderToTexture(this::renderTarget);
        }
    }

    public void renderTarget() {
        this.wrappedScene.renderToCurrentTarget(this.wrappedScene.getPreferredSize());
    }

    public void removed() {
        if (this.renderer != null) {
            this.renderer.close();
            this.renderer = null;
        }
    }

    protected void method_48579(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.updateSceneTexture();
        int previewX = this.field_22760;
        int previewY = this.field_22761;
        if (this.renderer != null) {
            int imageWidth = this.renderer.width;
            int imageHeight = this.renderer.height;
            LytSize origDim = new LytSize(imageWidth, imageHeight);
            LytSize boundary = new LytSize(this.field_22758, this.field_22759);
            LytSize newDim = ScenePreview.getScaledDimension(origDim, boundary);
            int x = previewX + 71;
            int y = previewY + 55;
            this.innerBlit(graphics.method_51448(), this.renderer, x -= newDim.width() / 2, x + newDim.width(), y -= newDim.height() / 2, y + newDim.height(), 0);
        }
        ModScreen.blitRect(graphics.method_51448(), this.field_22760 + 121, this.field_22761 + 3, 0.0f, 0.0f, 17.0f, 17.0f, 17, 17, new class_2960("blockprints", "textures/gui/gimbal/gimbal_cardinal.png"), 150);
    }

    void innerBlit(class_4587 pose, OffScreenRenderer osr, int x1, int x2, int y1, int y2, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (int)osr.fb.method_30277());
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = pose.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(1.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static LytSize getScaledDimension(LytSize imgSize, LytSize boundary) {
        int original_width = imgSize.width();
        int original_height = imgSize.height();
        int bound_width = boundary.width();
        int bound_height = boundary.height();
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new LytSize(new_width, new_height);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void method_25354(class_1144 $$0) {
    }
}

