/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.api.blockprints;

import fabric.com.hollingsworth.schematic.Constants;
import fabric.com.hollingsworth.schematic.api.blockprints.ApiError;
import fabric.com.hollingsworth.schematic.api.blockprints.auth.Auth;
import fabric.com.hollingsworth.schematic.api.blockprints.auth.BlockprintsToken;
import fabric.com.hollingsworth.schematic.api.blockprints.download.Download;
import fabric.com.hollingsworth.schematic.api.blockprints.favorites.Favorites;
import fabric.com.hollingsworth.schematic.api.blockprints.upload.Upload;
import fabric.com.hollingsworth.schematic.oauth.TokenLoader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.class_310;

public class BlockprintsApi {
    private static BlockprintsApi INSTANCE;
    private final Download downloadApi;
    private final Favorites favoritesApi;
    private final Upload uploadApi;
    private final Auth authApi;
    public final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(30L)).build();
    private BlockprintsToken bpToken;
    private static boolean loadedLocalToken;

    public BlockprintsApi() throws ApiError {
        this.downloadApi = new Download(this);
        this.favoritesApi = new Favorites(this);
        this.uploadApi = new Upload(this);
        this.authApi = new Auth(this);
        if (!loadedLocalToken) {
            this.bpToken = TokenLoader.loadToken();
            loadedLocalToken = true;
        }
    }

    public static BlockprintsApi getInstance() throws ApiError {
        UUID playerUuid = class_310.method_1551().field_1724.method_5667();
        if (INSTANCE == null) {
            INSTANCE = new BlockprintsApi();
        }
        if (INSTANCE.tokenExpired() || !playerUuid.equals(BlockprintsApi.INSTANCE.bpToken.requesterUUID()) && !Constants.isDev) {
            INSTANCE.setToken(null);
        }
        return INSTANCE;
    }

    public void setToken(BlockprintsToken token) {
        this.bpToken = token;
        if (token != null) {
            TokenLoader.writeToken(token);
        }
    }

    public HttpRequest.Builder getBuilder(boolean includeContentType) {
        HttpRequest.Builder req = HttpRequest.newBuilder();
        if (this.bpToken != null) {
            req = req.header("authorization", this.bpToken.token());
        }
        if (includeContentType) {
            req.header("Content-Type", "application/json");
        }
        return req;
    }

    public HttpRequest.Builder getBuilder() {
        return this.getBuilder(true);
    }

    public boolean tokenExpired() {
        return this.bpToken == null || this.bpToken.tokenExpired();
    }

    public Download download() {
        return this.downloadApi;
    }

    public Favorites favorites() {
        return this.favoritesApi;
    }

    public Upload upload() {
        return this.uploadApi;
    }

    public Auth auth() {
        return this.authApi;
    }

    static {
        loadedLocalToken = false;
    }
}

