/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.anti_mob_cheese.anti_mob_farm;

import com.robertx22.anti_mob_cheese.configs.CheeseConfig;
import com.robertx22.library_of_exile.components.ICap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ChunkCap
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("anti_mob_farm", "chunk_data");
    public static Capability<ChunkCap> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkCap>(){});
    final transient LazyOptional<ChunkCap> supp = LazyOptional.of(() -> this);
    static String DATA_LOC = "fr";
    private int freeKills;
    LevelChunk chunk;

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public static ChunkCap get(LevelChunk provider) {
        return (ChunkCap)provider.getCapability(INSTANCE).orElse(null);
    }

    public int getFreeKills() {
        return this.freeKills;
    }

    public ChunkCap(LevelChunk chunk) {
        this.freeKills = (Integer)CheeseConfig.get().FREE_MOB_KILLS_BEFORE_PENALTY_STARTS.get();
        this.chunk = chunk;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(DATA_LOC, this.freeKills);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.freeKills = nbt.m_128451_(DATA_LOC);
    }

    public void onLootChestOpened() {
        this.freeKills += ((Integer)CheeseConfig.get().ADD_FREE_KILLS_ON_CHEST_LOOT.get()).intValue();
    }

    public void onValidMobDeathByPlayer(LivingEntity en) {
        --this.freeKills;
    }

    public boolean isKillFree() {
        return this.freeKills > 0;
    }

    public String getCapIdForSyncing() {
        return "chunk_data_antimobfarm";
    }
}

