@echo off
chcp 65001 > nul
setlocal enabledelayedexpansion

:: ============ НАСТРОЙКИ ============
set "ZT_NETWORKS=e110b176e4245489"
set "INTERFACE_METRIC=1"
set "INTERFACE_MTU=1445"
set "ZT_INSTALLER_URL=https://download.zerotier.com/dist/ZeroTier%%20One.msi"
set "MOON_URL=https://files.mcbcorp.ru/defult/Repo/scripts/Zerotier/000000e110b176e4.moon"
:: ===================================

:: Абсолютные пути
set "ZT_CLI_PATH=C:\Program Files (x86)\ZeroTier\One\zerotier-cli.bat"
set "ZT_EXE_PATH=C:\ProgramData\ZeroTier\One\zerotier-one_x64.exe"
set "MOONS_DIR=C:\ProgramData\ZeroTier\One\moons.d"
set "MOON_FILE=%MOONS_DIR%\000000e110b176e4.moon"

:: Проверка админских прав
fsutil dirty query %SystemDrive% >nul 2>&1 || (
    echo Требуются права администратора!
    pause
    exit /b 1
)

:: Проверка установки ZeroTier
if not exist "%ZT_EXE_PATH%" (
    echo Установка ZeroTier...
    echo Пожалуйста, подождите...
    
    :: Скачивание установщика
    powershell -Command "Invoke-WebRequest '%ZT_INSTALLER_URL%' -OutFile 'ZTinstall.msi'" 2>&1 >nul
    if errorlevel 1 (
        echo Ошибка при скачивании установщика
        pause
        exit /b 1
    )
    
    :: Установка
    msiexec /i ZTinstall.msi /qn /norestart
    if errorlevel 1 (
        echo Ошибка при установке ZeroTier
        del /q ZTinstall.msi >nul 2>&1
        pause
        exit /b 1
    )
    
    :: Ожидание завершения установки
    echo Ожидание завершения установки...
    :wait_loop
    timeout /t 5 >nul
    if not exist "%ZT_EXE_PATH%" goto wait_loop
    
    del /q ZTinstall.msi >nul 2>&1
    echo Установка ZeroTier завершена
)

:: Ожидание запуска службы
echo Ожидание готовности ZeroTier...
:service_wait
"%ZT_CLI_PATH%" status 2>&1 | find "ONLINE" >nul
if errorlevel 1 (
    timeout /t 2 >nul
    goto service_wait
)

:: Настройка moon-сервера
set "MOON_ADDED=0"
if not exist "%MOONS_DIR%" (
    echo Создание папки moons.d...
    mkdir "%MOONS_DIR%"
    set "MOON_ADDED=1"
)

if not exist "%MOON_FILE%" (
    echo Скачивание moon-файла...
    powershell -Command "Invoke-WebRequest '%MOON_URL%' -OutFile '%MOON_FILE%'" 2>&1 >nul
    if errorlevel 1 (
        echo Ошибка при скачивании moon-файла
    ) else (
        echo Moon-файл успешно загружен
        set "MOON_ADDED=1"
    )
)

:: Перезапуск службы если был добавлен moon
if "%MOON_ADDED%"=="1" (
    echo Принудительный перезапуск службы после добавления moon...
    net stop ZeroTierOneService >nul 2>&1
    timeout /t 5 >nul
    net start ZeroTierOneService >nul 2>&1
    
    :: Проверка статуса службы
    sc query ZeroTierOneService | find "RUNNING" >nul
    if errorlevel 1 (
        echo Ошибка: служба ZeroTier не запустилась!
        exit /b 1
    ) else (
        echo Служба ZeroTier успешно перезапущена
    )
    
    :: Дополнительное ожидание после перезапуска
    echo Ожидание готовности ZeroTier после перезапуска...
    :post_restart_wait
    "%ZT_CLI_PATH%" status 2>&1 | find "ONLINE" >nul
    if errorlevel 1 (
        timeout /t 2 >nul
        goto post_restart_wait
    )
)

:: Основной цикл
for %%N in (%ZT_NETWORKS%) do (
    echo Обрабатываю сеть %%N
    
    :: Присоединение к сети
    "%ZT_CLI_PATH%" join %%N 2>&1 | find "200 join OK" >nul && (
        echo Успешно присоединились к сети %%N
    ) || (
        "%ZT_CLI_PATH%" listnetworks | find "%%N" >nul && (
            echo Уже подключен к сети %%N
        ) || (
            echo Ошибка при подключении к сети %%N
        )
    )
    
    :: Включение DNS для сети
    "%ZT_CLI_PATH%" set %%N allowDNS=1 >nul 2>&1 && (
        echo DNS для сети %%N включен
    )
    
    timeout /t 3 >nul
    
    :: Настройка интерфейса
    set "IFACE_NAME=ZeroTier One [%%N]"
    echo Настройка интерфейса для сети %%N...
    netsh interface ipv4 set interface "ZeroTier One [%%N]" metric=%INTERFACE_METRIC%
	netsh interface ipv4 set interface "ZeroTier One [%%N]" metric=%INTERFACE_METRIC% store=persistent
	netsh interface ipv4 set subinterface "ZeroTier One [%%N]" mtu=%INTERFACE_MTU%
    netsh interface ipv4 set subinterface "ZeroTier One [%%N]" mtu=%INTERFACE_MTU% store=persistent
    echo Параметры для сети %%N применены
    echo --------------------------
)

:: Финальный перезапуск службы для применения всех изменений
echo Финальный перезапуск службы ZeroTier...
net stop ZeroTierOneService >nul 2>&1
timeout /t 5 >nul
net start ZeroTierOneService >nul 2>&1

:: Проверка статуса службы
sc query ZeroTierOneService | find "RUNNING" >nul
if errorlevel 1 (
    echo Ошибка: служба ZeroTier не запустилась!
    exit /b 1
) else (
    echo Служба ZeroTier успешно перезапущена
)

echo Все операции завершены
pause