//Priority: 1
/**
  
  █▀▄▀█ █▀█ █▄░█ █░█ █▀▄▀█ █▀▀ █▄░█ ▀█▀ ▄▀█ █░░   █▀▀ ▀▄▀ █▀█ █▀▀ █▀█ █ █▀▀ █▄░█ █▀▀ █▀▀
  █░▀░█ █▄█ █░▀█ █▄█ █░▀░█ ██▄ █░▀█ ░█░ █▀█ █▄▄   ██▄ █░█ █▀▀ ██▄ █▀▄ █ ██▄ █░▀█ █▄▄ ██▄

  ☻/  * @file JEI script to hide items
  /▌  * @copyright KnightDexx's Modded Minecraft World | ModernGamingWorld | GeekTechMedia
  /\

*/
JEIEvents.hideItems(event => {

   let colors = ['cyan', 'purple', 'blue', 'brown', 'green', 'red', 'black', 'white', 'orange', 'magenta', 'light_blue', 'yellow', 'lime', 'pink', 'gray', 'light_gray']

   let itemsToHide = [
      //=== Misc items ===
      /ae2:facade/,
      'culturaldelights:eggplant_crate',
      /^createaddition:.+_rod$/,
      'cyclic:compressed_cobblestone',
      'createaddition:diamond_grit',
      'createaddition:copper_wire',
      /^createdeco:(copper)_(ingot|nugget)$/,
      'createdeco:gold_sheet_metal',
      'createdeco:iron_sheet_metal',
      'createdeco:brass_sheet_metal',
      'createdeco:copper_sheet_metal',
      'createdeco:industrial_iron_sheet_metal',
      'createdeco:zinc_sheet_metal',
      'createdeco:netherite_sheet',
      'createdeco:zinc_sheet',
      'create:powdered_obsidian',
      /^doggytalents:dog_bed$/,
      'eidolon:silver_helmet',
      'eidolon:silver_chestplate',
      'eidolon:silver_leggings',
      'eidolon:silver_boots',
      'eidolon:silver_sword',
      'eidolon:silver_pickaxe',
      'eidolon:silver_axe',
      'eidolon:silver_shovel',
      'eidolon:silver_hoe',
      'material_elements:silver_block',
      'forbidden_arcanus:reinforced_arcane_golden_blacksmith_gavel',
      'forbidden_arcanus:obsidian_blacksmith_gavel',
      /^ftbquests:.+/,
      'farmersdelight:beetroot_crate',
      'farmersdelight:carrot_crate',
      'farmersdelight:potato_crate',
      'farmersdelight:onion_crate',
      /^forcecraft:.+_flask$/,
      /^ironfurnaces:upgrade_.+/,
      /^immersiveposts:(stick)_(copper|gold|lead|silver|nickel|constantan|electrum|uranium)$/,
      'libraryferret:fake_iron_block',
      'libraryferret:fake_gold_block',
      'libraryferret:fake_emerald_block',
      'libraryferret:fake_diamond_block',
      'libraryferret:fake_netherite_block',
      'lootbundles:loot_bundle',
      'lootbundles:fragment',
      'mysticalagriculture:infusion_crystal',
      'mysticalagriculture:mithril_seeds',
      'mysticalagriculture:mithril_essence',
      'mysticalagriculture:rubber_essence',
      'mysticalagriculture:rubber_seeds',
      'minecraft:bedrock',
      'minecraft:end_portal_frame',
      'minecraft:damaged_anvil',
      'minecraft:ender_chest',
      'majruszsdifficulty:enderium_shard_ore',
      'majruszsdifficulty:enderium_ingot',
      'majruszsdifficulty:fragile_end_stone',
      'majruszsdifficulty:infested_end_stone',
      /^majruszsdifficulty:.+_treasure_bag$/,
      'occultism:lighted_air',
      'pneumaticcraft:plastic',
      /^quark:ancient_tome$/,
      /^quark:backpack$/,
      /^quark:.+_pouch$/,
      /^quark:.+_shard$/,
      /^quark:.+_crystal_cluster$/,
      /^quark:.+_leaves$/,
      'quark:beetroot_crate',
      'quark:apple_crate',
      'quark:sugar_cane_block',
      'quark:gunpowder_sack',
      'quark:carrot_crate',
      'quark:potato_crate',
      'quark:magnet',
      'quark:pipe',
      'quark:soul_compass',
      'quark:bottled_cloud',
      'quark:matrix_enchanter',
      'quark:chorus_weeds',
      'quark:chorus_twist',
      'quark:crate',
      'quark:bonded_ravager_hide',
      'quark:ravager_hide',
      'quark:music_disc_endermosh',
      'quark:abacus',
      'quark:glowcelium',
      /^reliquary:bullets\/neutral_bullet$/,
      /^reliquary:magazines\/neutral_magazine$/,
      /supplementaries:bamboo_spikes_tipped/,
      'supplementaries:flax_block',
      'supplementaries:flax',
      'supplementaries:wild_flax',
      'supplementaries:flax_seeds',
      'steampowered:bronze_sheet',
      'thermal:rose_gold_gear',
      'thermal:netherite_gear',
      /^twilightforest:.*_force_field$/,
      /^twilightforest:.*_castle_door$/,
      /^twilightforest:.*_cloud$/,
      'twilightforest:castle_brick',
      'twilightforest:uncrafting_table',
      'tombstone:grave_key',
      'tombstone:ghostly_shape',
      'tombstone:preservation',
      'tombstone:unstable_intangibleness',
      'tombstone:diversion',
      'tombstone:feather_fall',
      'tombstone:purification',
      'tombstone:true_sight',
      'tombstone:prayer',
      'tombstone:reach',
      'tombstone:lighting_aquatic_liferesistance',
      'tombstone:frost_resistance',
      'tombstone:bone_shield',
      'tombstone:bait',
      'tombstone:aquatic_life',
      /^tombstone:.*_of_/,

      //=== Creative Items ===
      'ae2:creative_energy_cell',
      'ars_nouveau:creative_source_jar',
      'botania:infrangible_platform',
      'botania:corporea_spark_creative',
      'buildinggadgets:construction_paste_container_creative',
      'create:creative_fluid_tank',
      'create:creative_crate',
      'create:handheld_worldshaper',
      'cyclic:battery_infinite',
      'mekanism:creative_chemical_tank',
      'mekanism:creative_fluid_tank',

      //=== Mod Buckets Hidden ===
      /^ad_astra:.+_bucket$/,
      /^aquaculture:.+_bucket$/,
      'ars_nouveau:bucket_of_mana',
      'ars_nouveau:bucket_of_source',
      /^bigreactors:.+_bucket$/,
      /^blue_skies:ventium_.+_bucket$/,
      /^blue_skies:molten_.+_bucket$/,
      'cnb:cindershell_bucket',
      'createaddition:seed_oil_bucket',
      /^cyclic:.*_bucket$/,
      /^create:.*_bucket$/,
      /^createaddition:.*_bucket$/,
      /^createchromaticreturn:.*_bucket$/,
      /^earthmobsmod:.+_bucket$/,
      /^experienceobelisk:.+_bucket$/,
      /^fishofthieves:.+_bucket$/,
      /^forcecraft:.+_bucket$/,
      /^forbidden_arcanus:.+_bucket$/,
      /^hexerei:.+_bucket$/,
      /^immersive(engineering|petroleum):.+_bucket$/,
      /^industrialforegoing:.+_bucket$/,
      /^minecraft:.+_bucket$/,
      /^mekanismgenerators:.+_bucket$/,
      /^mekanism:.+_bucket$/,
      /^mysticalagradditions:.+_bucket$/,
      /^naturalist:.+_bucket$/,
      /^pneumaticcraft:.+_bucket$/,
      /^quark:.+_bucket$/,
      /^sushigocrafting:.+_bucket$/,
      /^thermal:.+_(bucket)$/,
      /^undergarden:.+_bucket$/,
      /^upgrade_aquatic:.+_bucket$/,

      //=== Mod Ores ===
      /^ad_astra:.+_ore$/,
      'alltheores:other_platinum_ore',
      'alltheores:deepslate_iridium_ore',
      'alltheores:end_iridium_ore',
      'alltheores:end_platinum_ore',
      'alltheores:deepslate_peridot_ore',
      /^blue_skies:.+_ore$/,
      /^bigreactors:.+_ore$/,
      /^forcecraft:.+_ore$/,
      'forbidden_arcanus:deepslate_arcane_crystal_ore',
      /^mysticalagriculture:.+_ore$/,
      /^mysticalagradditions:.+_ore$/,
      /^mythicbotany:.+_ore$/,
      'occultism:iesnium_ore_natural',
      /^rftoolsbase:dimensionalshard_.+/,
      'thermal:apatite_ore',
      'thermal:deepslate_apatite_ore',
      'thermal:deepslate_cinnabar_ore',
      'thermal:deepslate_niter_ore',
      'thermal:deepslate_sulfur_ore',
      /^undergarden:.+_ore$/,


      //=== Mods Hidden (Use jei_additions.js script to add something if u don't want it hidden) ===

      '@additionalbanners',
      '@conjurer_illager',
      '@chipped',
      '@rechiseled',
      '@pickletweaks',
      '@wandering_trapper',

      //=== Spawners, Eggs, and more ===
      /^aquaculture:.+_spawn_egg$/,
      /^ad_astra:.+_spawn_egg$/,
      /^ars_nouveau:.+_se$/,
      /^blue_skies:.+_spawn_egg$/,
      /^buzzier_bees:.+_spawn_egg$/,
      /^creeperoverhaul:.+_spawn_egg$/,
      /^cataclysm:cataclysm:.+_spawn_egg$/,
      /^doom:.+_spawn_egg$/,
      /^enderzoology:.+_spawn_egg$/,
      /^environmental:.+_spawn_egg$/,
      /^extendedmushrooms:.+_spawn_egg$/,
      /^earthmobsmod:.+_spawn_egg$/,
      /^enchantwithmob:.+_spawn_egg$/,
      /^forcecraft:.+_spawn_egg$/,
      /^fishofthieves:.+_spawn_egg$/,
      /^goblintraders:.+_spawn_egg$/,
      /^guardvillagers:.+_spawn_egg$/,
      /^graveyard:.+_spawn_egg$/,
      /^hexerei:.+_spawn_egg$/,
      /^immersiveengineering:.+_spawn_egg$/,
      /^kobolds:.+_spawn_egg$/,
      /^takesapillage:.+_spawn_egg$/,
      /^the_bumblezone:.+_spawn_egg$/,
      /^monsterplus:.+_spawn_egg$/,
      /^meetyourfight:.+_spawn_egg$/,
      /^minecraft:.+_spawn_egg$/,
      /^mobcompack:.+_egg$/,
      /^majruszsdifficulty:.+_spawn_egg$/,
      /^mutantmonsters:.+_spawn_egg$/,
      /^mythicbotany:.+_spawn_egg$/,
      /^nasty:.+_spawn_egg$/,
      /^naturalist:.+_spawn_egg$/,
      /^quark:.+_spawn_egg$/,
      /^raided:.+_spawn_egg$/,
      /^rottencreatures:.+_spawn_egg$/,
      /^twilightforest:.+_spawn_egg$/,
      /^undergarden:.+_spawn_egg$/,
      /^upgrade_aquatic:.+_spawn_egg$/,
      /^snowpig:.+_spawn_egg$/,
      /^thermal:.+_spawn_egg$/,
      /^vinery:.+_spawn_egg$/,
      'occultism:spawn_egg/afrit',
      'occultism:spawn_egg/afrit_wild',
      'occultism:spawn_egg/djinni',
      'occultism:spawn_egg/familiar_bat',
      'occultism:spawn_egg/familiar_beaver',
      'occultism:spawn_egg/familiar_beholder',
      'occultism:spawn_egg/familiar_blacksmith',
      'occultism:spawn_egg/familiar_chimera',
      'occultism:spawn_egg/familiar_cthulhu',
      'occultism:spawn_egg/familiar_deer',
      'occultism:spawn_egg/familiar_devil',
      'occultism:spawn_egg/familiar_dragon',
      'occultism:spawn_egg/familiar_fairy',
      'occultism:spawn_egg/familiar_goat',
      'occultism:spawn_egg/familiar_greedy',
      'occultism:spawn_egg/familiar_guardian',
      'occultism:spawn_egg/familiar_headless',
      'occultism:spawn_egg/familiar_mummy',
      'occultism:spawn_egg/familiar_parrot',
      'occultism:spawn_egg/familiar_shub_niggurath',
      'occultism:spawn_egg/foliot',
      'occultism:spawn_egg/marid',
      'occultism:spawn_egg/otherworld_bird',
      'occultism:spawn_egg/possessed_enderman',
      'occultism:spawn_egg/possessed_endermite',
      'occultism:spawn_egg/possessed_skeleton',
      'occultism:spawn_egg/wild_hunt_skeleton',
      'occultism:spawn_egg/wild_hunt_wither_skeleton',
      'occultism:debug_foliot_lumberjack',
      'occultism:debug_foliot_transport_items',
      'occultism:debug_foliot_cleaner',
      'occultism:debug_foliot_trader',
      'occultism:debug_djinni_manage_machine',
      'occultism:debug_djinni_test',
      /^cnb:.+_egg$/,
      'hunterillager:spawnegg_hunterillager',
      'inventorypets:easter_egg',
      /^twilightforest:boss_spawner_.+/
   ]

   itemsToHide.forEach(i => event.hide(i))
   colors.forEach(c => {
      if (c != 'light_blue') event.hide(`/^refinedstorage:${c}_.+/`)
   })

})