/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.DrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.client.gui.ClientDetachedDrawerTooltip;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelGeometry;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.ForgeDecoratedModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.CombinedModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.DrawerModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.MaterialModelDecorator;
import com.jaquadro.minecraft.storagedrawers.client.renderer.BlockEntityDrawersRenderer;
import com.jaquadro.minecraft.storagedrawers.client.renderer.BlockEntityFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerScreen;
import com.jaquadro.minecraft.storagedrawers.inventory.FramingTableScreen;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.DetachedDrawerTooltip;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.KeyringTooltip;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="storagedrawers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModBusSubscriber {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.DRAWER_CONTAINER_1.get()), DrawerScreen.Slot1::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.DRAWER_CONTAINER_2.get()), DrawerScreen.Slot2::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.DRAWER_CONTAINER_4.get()), DrawerScreen.Slot4::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.DRAWER_CONTAINER_COMP_2.get()), DrawerScreen.Compacting2::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.DRAWER_CONTAINER_COMP_3.get()), DrawerScreen.Compacting3::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.FRAMING_TABLE.get()), FramingTableScreen::new);
        });
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ModBlockEntities.getBlockEntityTypesWithRenderers().forEach(ro -> event.registerBlockEntityRenderer((BlockEntityType)ro.get(), BlockEntityDrawersRenderer::new));
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.FRAMING_TABLE.get(), BlockEntityFramingRenderer::new);
    }

    @SubscribeEvent
    public static void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(KeyringTooltip.class, ClientBundleTooltip::new);
        event.register(DetachedDrawerTooltip.class, ClientDetachedDrawerTooltip::new);
    }

    @SubscribeEvent
    public static void registerTextures(TextureStitchEvent event) {
        if (!ModBlocks.OAK_FULL_DRAWERS_1.isPresent()) {
            StorageDrawers.log.warn("Block objects not set in TextureStitchEvent.  Is your mod environment broken?");
            return;
        }
        DrawerModelGeometry.loadGeometryData();
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.ModifyBakingResult event) {
        if (!ModBlocks.OAK_FULL_DRAWERS_1.isPresent()) {
            StorageDrawers.log.warn("Block objects not set in ModelBakeEvent.  Is your mod environment broken?");
            return;
        }
        DrawerModelStore.getModelLocations().forEach(loc -> DrawerModelStore.tryAddModel(loc, (BakedModel)event.getModels().get(loc)));
        ModBlocks.getDrawers().forEach(blockDrawers -> ClientModBusSubscriber.replaceBlock(event, (Block)blockDrawers, ClientModBusSubscriber::makeStandardDrawerModel));
        ModBlocks.getFramedDrawers().forEach(blockDrawers -> ClientModBusSubscriber.replaceBlock(event, (Block)blockDrawers, ClientModBusSubscriber::makeFramedStandardDrawerModel));
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_COMPACTING_DRAWERS_2.get(), ClientModBusSubscriber::makeFramedComp2DrawerModel);
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_2.get(), ClientModBusSubscriber::makeFramedComp2DrawerModel);
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_COMPACTING_DRAWERS_3.get(), ClientModBusSubscriber::makeFramedComp3DrawerModel);
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_3.get(), ClientModBusSubscriber::makeFramedComp3DrawerModel);
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_TRIM.get(), ClientModBusSubscriber::makeFramedTrimModel);
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_CONTROLLER.get(), ClientModBusSubscriber::makeFramedControllerModel);
        ClientModBusSubscriber.replaceBlock(event, (Block)ModBlocks.FRAMED_CONTROLLER_IO.get(), ClientModBusSubscriber::makeFramedControllerIOModel);
        List.of("framed_full_drawers_4", "framed_full_drawers_2", "framed_full_drawers_1", "framed_half_drawers_4", "framed_half_drawers_2", "framed_half_drawers_1").forEach(d -> {
            ModelResourceLocation testResource = new ModelResourceLocation(new ResourceLocation("storagedrawers", d), "inventory");
            BakedModel test = (BakedModel)event.getModels().get(testResource);
            if (test != null) {
                event.getModels().put(testResource, ClientModBusSubscriber.makeFramedStandardDrawerModel(test));
            }
        });
        List.of("framed_compacting_drawers_2", "framed_compacting_half_drawers_2").forEach(d -> {
            ModelResourceLocation testResource = new ModelResourceLocation(new ResourceLocation("storagedrawers", d), "inventory");
            BakedModel test = (BakedModel)event.getModels().get(testResource);
            if (test != null) {
                event.getModels().put(testResource, ClientModBusSubscriber.makeFramedComp2DrawerModel(test));
            }
        });
        List.of("framed_compacting_drawers_3", "framed_compacting_half_drawers_3").forEach(d -> {
            ModelResourceLocation testResource = new ModelResourceLocation(new ResourceLocation("storagedrawers", d), "inventory");
            BakedModel test = (BakedModel)event.getModels().get(testResource);
            if (test != null) {
                event.getModels().put(testResource, ClientModBusSubscriber.makeFramedComp3DrawerModel(test));
            }
        });
        List.of("framed_trim").forEach(d -> {
            ModelResourceLocation testResource = new ModelResourceLocation(new ResourceLocation("storagedrawers", d), "inventory");
            BakedModel test = (BakedModel)event.getModels().get(testResource);
            if (test != null) {
                event.getModels().put(testResource, ClientModBusSubscriber.makeFramedTrimModel(test));
            }
        });
        List.of("framed_controller").forEach(d -> {
            ModelResourceLocation testResource = new ModelResourceLocation(new ResourceLocation("storagedrawers", d), "inventory");
            BakedModel test = (BakedModel)event.getModels().get(testResource);
            if (test != null) {
                event.getModels().put(testResource, ClientModBusSubscriber.makeFramedControllerModel(test));
            }
        });
        List.of("framed_controller_io").forEach(d -> {
            ModelResourceLocation testResource = new ModelResourceLocation(new ResourceLocation("storagedrawers", d), "inventory");
            BakedModel test = (BakedModel)event.getModels().get(testResource);
            if (test != null) {
                event.getModels().put(testResource, ClientModBusSubscriber.makeFramedControllerIOModel(test));
            }
        });
    }

    public static void replaceBlock(ModelEvent.ModifyBakingResult event, Block block, Function<BakedModel, BakedModel> replacer) {
        BakedModel missing = (BakedModel)event.getModels().get(ModelBakery.f_119230_);
        for (BlockState state : block.m_49965_().m_61056_()) {
            ModelResourceLocation modelResource = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel parentModel = (BakedModel)event.getModels().get(modelResource);
            if (parentModel == null) {
                StorageDrawers.log.warn("Got back null model from ModelBakeEvent.ModelManager for resource " + modelResource.toString());
                continue;
            }
            if (parentModel == missing || !DrawerModelStore.INSTANCE.isTargetedModel(modelResource)) continue;
            event.getModels().put(modelResource, replacer.apply(parentModel));
        }
    }

    static BakedModel makeStandardDrawerModel(BakedModel parentModel) {
        DrawerModelDecorator decorator = new DrawerModelDecorator(DrawerModelStore.INSTANCE);
        return new ForgeDecoratedModel<DrawerModelContext>(parentModel, decorator, DrawerModelProperties.INSTANCE);
    }

    static BakedModel makeFramedDrawerModel(BakedModel parentModel, DrawerModelStore.FrameMatSet matSet) {
        CombinedModelDecorator<DrawerModelContext> decorator = new CombinedModelDecorator<DrawerModelContext>();
        decorator.add(new DrawerModelDecorator(DrawerModelStore.INSTANCE));
        decorator.add(new MaterialModelDecorator.FacingSizedSlotted(matSet, true));
        return new ForgeDecoratedModel<DrawerModelContext>(parentModel, decorator, DrawerModelProperties.INSTANCE);
    }

    static BakedModel makeFramedStandardDrawerModel(BakedModel parentModel) {
        return ClientModBusSubscriber.makeFramedDrawerModel(parentModel, DrawerModelStore.FramedStandardDrawerMaterials);
    }

    static BakedModel makeFramedCompDrawerModel(BakedModel parentModel, DrawerModelStore.FrameMatSet matSet) {
        CombinedModelDecorator<DrawerModelContext> decorator = new CombinedModelDecorator<DrawerModelContext>();
        decorator.add(new DrawerModelDecorator(DrawerModelStore.INSTANCE));
        decorator.add(new MaterialModelDecorator.FacingSizedOpen(matSet, true));
        return new ForgeDecoratedModel<DrawerModelContext>(parentModel, decorator, DrawerModelProperties.INSTANCE);
    }

    static BakedModel makeFramedComp2DrawerModel(BakedModel parentModel) {
        return ClientModBusSubscriber.makeFramedCompDrawerModel(parentModel, DrawerModelStore.FramedComp2DrawerMaterials);
    }

    static BakedModel makeFramedComp3DrawerModel(BakedModel parentModel) {
        return ClientModBusSubscriber.makeFramedCompDrawerModel(parentModel, DrawerModelStore.FramedComp3DrawerMaterials);
    }

    static BakedModel makeFramedTrimModel(BakedModel parentModel) {
        MaterialModelDecorator.Single decorator = new MaterialModelDecorator.Single(DrawerModelStore.FramedTrimMaterials, true);
        return new ForgeDecoratedModel<FramedModelContext>(parentModel, decorator, FramedModelProperties.INSTANCE);
    }

    static BakedModel makeFramedControllerModel(BakedModel parentModel) {
        MaterialModelDecorator.Facing decorator = new MaterialModelDecorator.Facing(DrawerModelStore.FramedControllerMaterials, true);
        return new ForgeDecoratedModel<FramedModelContext>(parentModel, decorator, FramedModelProperties.INSTANCE);
    }

    static BakedModel makeFramedControllerIOModel(BakedModel parentModel) {
        MaterialModelDecorator.Single decorator = new MaterialModelDecorator.Single(DrawerModelStore.FramedControllerIOMaterials, true);
        return new ForgeDecoratedModel<FramedModelContext>(parentModel, decorator, FramedModelProperties.INSTANCE);
    }
}

