/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.config;

import com.github.alexthe666.citadel.config.biome.SpawnBiomeConfig;
import com.github.alexthe666.citadel.config.biome.SpawnBiomeData;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.config.DefaultBiomes;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeConfig {
    public static Pair<String, SpawnBiomeData> oreGenBiomes = Pair.of((Object)"iceandfire:ore_gen_biomes", (Object)DefaultBiomes.OVERWORLD);
    public static Pair<String, SpawnBiomeData> sapphireBiomes = Pair.of((Object)"iceandfire:sapphire_gen_biomes", (Object)DefaultBiomes.VERY_SNOWY);
    public static Pair<String, SpawnBiomeData> fireLilyBiomes = Pair.of((Object)"iceandfire:fire_lily_biomes", (Object)DefaultBiomes.VERY_HOT);
    public static Pair<String, SpawnBiomeData> frostLilyBiomes = Pair.of((Object)"iceandfire:frost_lily_biomes", (Object)DefaultBiomes.VERY_SNOWY);
    public static Pair<String, SpawnBiomeData> lightningLilyBiomes = Pair.of((Object)"iceandfire:lightning_lily_biomes", (Object)DefaultBiomes.SAVANNAS);
    public static Pair<String, SpawnBiomeData> fireDragonBiomes = Pair.of((Object)"iceandfire:fire_dragon_biomes", (Object)DefaultBiomes.FIREDRAGON_ROOST);
    public static Pair<String, SpawnBiomeData> fireDragonCaveBiomes = Pair.of((Object)"iceandfire:fire_dragon_cave_biomes", (Object)DefaultBiomes.FIREDRAGON_CAVE);
    public static Pair<String, SpawnBiomeData> iceDragonBiomes = Pair.of((Object)"iceandfire:ice_dragon_biomes", (Object)DefaultBiomes.ICEDRAGON_ROOST);
    public static Pair<String, SpawnBiomeData> iceDragonCaveBiomes = Pair.of((Object)"iceandfire:ice_dragon_cave_biomes", (Object)DefaultBiomes.ICEDRAGON_CAVE);
    public static Pair<String, SpawnBiomeData> lightningDragonBiomes = Pair.of((Object)"iceandfire:lightning_dragon_biomes", (Object)DefaultBiomes.LIGHTNING_ROOST);
    public static Pair<String, SpawnBiomeData> lightningDragonCaveBiomes = Pair.of((Object)"iceandfire:lightning_dragon_cave_biomes", (Object)DefaultBiomes.LIGHTNING_CAVE);
    public static Pair<String, SpawnBiomeData> cyclopsCaveBiomes = Pair.of((Object)"iceandfire:cyclops_cave_biomes", (Object)DefaultBiomes.BEACHES);
    public static Pair<String, SpawnBiomeData> hippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_biomes", (Object)DefaultBiomes.HILLS);
    public static Pair<String, SpawnBiomeData> pixieBiomes = Pair.of((Object)"iceandfire:pixie_village_biomes", (Object)DefaultBiomes.PIXIES);
    public static Pair<String, SpawnBiomeData> hippocampusBiomes = Pair.of((Object)"iceandfire:hippocampus_biomes", (Object)DefaultBiomes.OCEANS);
    public static Pair<String, SpawnBiomeData> seaSerpentBiomes = Pair.of((Object)"iceandfire:sea_serpent_biomes", (Object)DefaultBiomes.OCEANS);
    public static Pair<String, SpawnBiomeData> sirenBiomes = Pair.of((Object)"iceandfire:siren_biomes", (Object)DefaultBiomes.OCEANS);
    public static Pair<String, SpawnBiomeData> amphithereBiomes = Pair.of((Object)"iceandfire:amphithere_biomes", (Object)DefaultBiomes.JUNGLE);
    public static Pair<String, SpawnBiomeData> desertMyrmexBiomes = Pair.of((Object)"iceandfire:desert_myrmex_biomes", (Object)DefaultBiomes.DESERT);
    public static Pair<String, SpawnBiomeData> jungleMyrmexBiomes = Pair.of((Object)"iceandfire:jungle_myrmex_biomes", (Object)DefaultBiomes.JUNGLE);
    public static Pair<String, SpawnBiomeData> snowyTrollBiomes = Pair.of((Object)"iceandfire:snowy_troll_biomes", (Object)DefaultBiomes.SNOWY);
    public static Pair<String, SpawnBiomeData> forestTrollBiomes = Pair.of((Object)"iceandfire:forest_troll_biomes", (Object)DefaultBiomes.WOODLAND);
    public static Pair<String, SpawnBiomeData> mountainTrollBiomes = Pair.of((Object)"iceandfire:mountain_troll_biomes", (Object)DefaultBiomes.VERY_HILLY);
    public static Pair<String, SpawnBiomeData> stymphalianBiomes = Pair.of((Object)"iceandfire:stymphalian_bird_biomes", (Object)DefaultBiomes.SWAMPS);
    public static Pair<String, SpawnBiomeData> hydraBiomes = Pair.of((Object)"iceandfire:hydra_cave_biomes", (Object)DefaultBiomes.SWAMPS);
    public static Pair<String, SpawnBiomeData> mausoleumBiomes = Pair.of((Object)"iceandfire:mausoleum_biomes", (Object)DefaultBiomes.MAUSOLEUM);
    public static Pair<String, SpawnBiomeData> graveyardBiomes = Pair.of((Object)"iceandfire:graveyard_biomes", (Object)DefaultBiomes.GRAVEYARD);
    public static Pair<String, SpawnBiomeData> gorgonTempleBiomes = Pair.of((Object)"iceandfire:gorgon_temple_biomes", (Object)DefaultBiomes.BEACHES);
    public static Pair<String, SpawnBiomeData> cockatriceBiomes = Pair.of((Object)"iceandfire:cockatrice_biomes", (Object)DefaultBiomes.SAVANNAS);
    public static Pair<String, SpawnBiomeData> deathwormBiomes = Pair.of((Object)"iceandfire:deathworm_biomes", (Object)DefaultBiomes.DESERT);
    public static Pair<String, SpawnBiomeData> wanderingCyclopsBiomes = Pair.of((Object)"iceandfire:wandering_cyclops_biomes", (Object)DefaultBiomes.PLAINS);
    public static Pair<String, SpawnBiomeData> lightningDragonSkeletonBiomes = Pair.of((Object)"iceandfire:lightning_dragon_skeleton_biomes", (Object)DefaultBiomes.SAVANNAS);
    public static Pair<String, SpawnBiomeData> fireDragonSkeletonBiomes = Pair.of((Object)"iceandfire:fire_dragon_skeleton_biomes", (Object)DefaultBiomes.DESERT);
    public static Pair<String, SpawnBiomeData> iceDragonSkeletonBiomes = Pair.of((Object)"iceandfire:ice_dragon_skeleton_biomes", (Object)DefaultBiomes.VERY_SNOWY);
    public static Pair<String, SpawnBiomeData> blackHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_black_biomes", (Object)DefaultBiomes.HIPPOGRYPH_BLACK);
    public static Pair<String, SpawnBiomeData> brownHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_brown_biomes", (Object)DefaultBiomes.VERY_HILLY);
    public static Pair<String, SpawnBiomeData> grayHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_gray_biomes", (Object)DefaultBiomes.HIPPOGRYPH_GRAY);
    public static Pair<String, SpawnBiomeData> chestnutHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_chestnut_biomes", (Object)DefaultBiomes.HIPPOGRYPH_CHESTNUT);
    public static Pair<String, SpawnBiomeData> creamyHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_creamy_biomes", (Object)DefaultBiomes.HIPPOGRYPH_CREAMY);
    public static Pair<String, SpawnBiomeData> darkBrownHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_dark_brown_biomes", (Object)DefaultBiomes.HIPPOGRYPH_DARK_BROWN);
    public static Pair<String, SpawnBiomeData> whiteHippogryphBiomes = Pair.of((Object)"iceandfire:hippogryph_white_biomes", (Object)DefaultBiomes.HIPPOGRYPH_WHITE);
    private static boolean init = false;
    private static final Map<String, SpawnBiomeData> biomeConfigValues = new HashMap<String, SpawnBiomeData>();

    public static void init() {
        try {
            for (Field f : BiomeConfig.class.getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Pair)) continue;
                String id = (String)((Pair)obj).getLeft();
                SpawnBiomeData data = (SpawnBiomeData)((Pair)obj).getRight();
                biomeConfigValues.put(id, SpawnBiomeConfig.create((ResourceLocation)new ResourceLocation(id), (SpawnBiomeData)data));
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Encountered error building iceandfire biome config .json files");
            e.printStackTrace();
        }
        init = true;
    }

    private static ResourceLocation getBiomeName(Holder<Biome> biome) {
        return (ResourceLocation)biome.m_203439_().map(resourceKey -> resourceKey.m_135782_(), noKey -> null);
    }

    public static boolean test(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome, ResourceLocation name) {
        if (!init) {
            BiomeConfig.init();
        }
        return biomeConfigValues.get(entry.getKey()).matches(biome, name);
    }

    public static boolean test(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome) {
        return BiomeConfig.test(entry, biome, BiomeConfig.getBiomeName(biome));
    }

    public static boolean test(Pair<String, SpawnBiomeData> entry, Holder.Reference<Biome> biome) {
        return BiomeConfig.test(entry, biome, biome.m_205785_().m_135782_());
    }
}

