/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.modifier.custom.ExplosionModifier;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class AttachmentDataUtils {
    public static void getAllAttachmentData(ItemStack gunItem, GunData gunData, Consumer<AttachmentData> dataConsumer) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        for (AttachmentType type : AttachmentType.values()) {
            ResourceLocation attachmentId;
            if (type == AttachmentType.NONE || DefaultAssets.isEmptyAttachmentId(attachmentId = iGun.getAttachmentId(gunItem, type))) continue;
            AttachmentData attachmentData = gunData.getExclusiveAttachments().get(attachmentId);
            if (attachmentData != null) {
                dataConsumer.accept(attachmentData);
                continue;
            }
            TimelessAPI.getCommonAttachmentIndex(attachmentId).ifPresent(index -> dataConsumer.accept(index.getData()));
        }
    }

    public static int getAmmoCountWithAttachment(ItemStack gunItem, GunData gunData) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return gunData.getAmmoAmount();
        }
        int[] extendedMagAmmoAmount = gunData.getExtendedMagAmmoAmount();
        if (extendedMagAmmoAmount == null) {
            return gunData.getAmmoAmount();
        }
        ResourceLocation attachmentId = iGun.getAttachmentId(gunItem, AttachmentType.EXTENDED_MAG);
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return gunData.getAmmoAmount();
        }
        AttachmentData attachmentData = gunData.getExclusiveAttachments().get(attachmentId);
        if (attachmentData != null) {
            int level = attachmentData.getExtendedMagLevel();
            if (level <= 0 || level > 3) {
                return gunData.getAmmoAmount();
            }
            return extendedMagAmmoAmount[level];
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> {
            int level = index.getData().getExtendedMagLevel();
            if (level <= 0 || level > 3) {
                return gunData.getAmmoAmount();
            }
            return extendedMagAmmoAmount[level - 1];
        }).orElse(gunData.getAmmoAmount());
    }

    public static double getWightWithAttachment(ItemStack gunItem, GunData gunData) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return gunData.getWeight();
        }
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        for (AttachmentType type : AttachmentType.values()) {
            ResourceLocation id = iGun.getAttachmentId(gunItem, type);
            AttachmentData attachmentData = gunData.getExclusiveAttachments().get(id);
            if (attachmentData != null) {
                Object obj;
                JsonProperty<?> m = attachmentData.getModifier().get("weight_modifier");
                if (m != null && (obj = m.getValue()) instanceof Modifier) {
                    Modifier modifier = (Modifier)obj;
                    modifiers.add(modifier);
                    continue;
                }
                Modifier modifier = new Modifier();
                modifier.setAddend(attachmentData.getWeight());
                modifiers.add(modifier);
                continue;
            }
            TimelessAPI.getCommonAttachmentIndex(id).ifPresent(index -> {
                Object patt4722$temp;
                JsonProperty<?> m = index.getData().getModifier().get("weight_modifier");
                if (m != null && (patt4722$temp = m.getValue()) instanceof Modifier) {
                    Modifier modifier = (Modifier)patt4722$temp;
                    modifiers.add(modifier);
                } else {
                    Modifier modifier = new Modifier();
                    modifier.setAddend(index.getData().getWeight());
                    modifiers.add(modifier);
                }
            });
        }
        return AttachmentPropertyManager.eval(modifiers, (double)gunData.getWeight());
    }

    public static boolean isExplodeEnabled(ItemStack gunItem, GunData gunData) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            if (gunData.getBulletData().getExplosionData() != null) {
                return gunData.getBulletData().getExplosionData().isExplode();
            }
            return false;
        }
        return AttachmentDataUtils.calcBooleanValue(gunItem, gunData, "explosion", ExplosionModifier.ExplosionModifierValue.class, ExplosionModifier.ExplosionModifierValue::isExplode);
    }

    public static double getArmorIgnoreWithAttachment(ItemStack gunItem, GunData gunData) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return 0.0;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float finalBase = extraDamage != null ? extraDamage.getArmorIgnore() : 0.0f;
        finalBase = fireModeAdjustData != null ? finalBase + fireModeAdjustData.getArmorIgnore() : finalBase;
        finalBase = (float)((double)finalBase * (Double)SyncConfig.ARMOR_IGNORE_BASE_MULTIPLIER.get());
        List<Modifier> modifiers = AttachmentDataUtils.getModifiers(gunItem, gunData, "armor_ignore");
        return AttachmentPropertyManager.eval(modifiers, (double)finalBase);
    }

    public static double getHeadshotMultiplier(ItemStack gunItem, GunData gunData) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return 0.0;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float finalBase = extraDamage != null ? extraDamage.getHeadShotMultiplier() : 0.0f;
        finalBase = fireModeAdjustData != null ? finalBase + fireModeAdjustData.getHeadShotMultiplier() : finalBase;
        finalBase = (float)((double)finalBase * (Double)SyncConfig.HEAD_SHOT_BASE_MULTIPLIER.get());
        List<Modifier> modifiers = AttachmentDataUtils.getModifiers(gunItem, gunData, "head_shot");
        return AttachmentPropertyManager.eval(modifiers, (double)finalBase);
    }

    public static double getDamageWithAttachment(ItemStack gunItem, GunData gunData) {
        float finalBase;
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return 0.0;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float rawDamage = bulletData.getDamageAmount();
        float f = finalBase = fireModeAdjustData != null ? fireModeAdjustData.getDamageAmount() : 0.0f;
        finalBase = extraDamage != null && extraDamage.getDamageAdjust() != null ? (finalBase += extraDamage.getDamageAdjust().get(0).getDamage()) : (finalBase += rawDamage);
        finalBase = (float)((double)finalBase * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get());
        List<Modifier> modifiers = AttachmentDataUtils.getModifiers(gunItem, gunData, "damage");
        return AttachmentPropertyManager.eval(modifiers, (double)finalBase);
    }

    private static List<Modifier> getModifiers(ItemStack gunItem, GunData gunData, String id) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return new ArrayList<Modifier>();
        }
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        for (AttachmentType type : AttachmentType.values()) {
            Object obj;
            JsonProperty<?> m;
            ResourceLocation attachmentId = iGun.getAttachmentId(gunItem, type);
            if (DefaultAssets.isEmptyAttachmentId(attachmentId)) continue;
            AttachmentData attachmentData = gunData.getExclusiveAttachments().get(attachmentId);
            if (attachmentData != null) {
                Object obj2;
                JsonProperty<?> m2 = attachmentData.getModifier().get(id);
                if (m2 == null || !((obj2 = m2.getValue()) instanceof Modifier)) continue;
                Modifier modifier = (Modifier)obj2;
                modifiers.add(modifier);
                continue;
            }
            CommonAttachmentIndex index = TimelessAPI.getCommonAttachmentIndex(attachmentId).orElse(null);
            if (index == null || (m = index.getData().getModifier().get(id)) == null || !((obj = m.getValue()) instanceof Modifier)) continue;
            Modifier modifier = (Modifier)obj;
            modifiers.add(modifier);
        }
        return modifiers;
    }

    private static <T> boolean calcBooleanValue(ItemStack gunItem, GunData gunData, String id, Class<T> clazz, BooleanResolver<T> resolver) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return false;
        }
        for (AttachmentType type : AttachmentType.values()) {
            JsonProperty<?> m;
            boolean value;
            CommonAttachmentIndex index;
            JsonProperty<?> m2;
            boolean value2;
            AttachmentData attachmentData;
            ResourceLocation attachmentId = iGun.getAttachmentId(gunItem, type);
            if (DefaultAssets.isEmptyAttachmentId(attachmentId) || !((attachmentData = gunData.getExclusiveAttachments().get(attachmentId)) != null ? (value2 = AttachmentDataUtils.resolve(m2 = attachmentData.getModifier().get(id), resolver, clazz)) : (index = (CommonAttachmentIndex)TimelessAPI.getCommonAttachmentIndex(attachmentId).orElse(null)) != null && (value = AttachmentDataUtils.resolve(m = index.getData().getModifier().get(id), resolver, clazz)))) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean resolve(JsonProperty<?> raw, BooleanResolver<T> data, Class<T> type) {
        if (raw != null && raw.getValue() != null && raw.getValue().getClass().equals(type)) {
            return data.apply(raw.getValue());
        }
        return false;
    }

    @FunctionalInterface
    public static interface BooleanResolver<T> {
        public boolean apply(T var1);
    }
}

