/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.GunItemDataAccessor;
import com.tacz.guns.command.sub.DebugCommand;
import com.tacz.guns.debug.GunMeleeDebug;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunFire;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.pojo.data.attachment.EffectData;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.CycleTaskHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class ModernKineticGunItem
extends AbstractGunItem
implements GunItemDataAccessor {
    public static final String TYPE_NAME = "modern_kinetic";
    private static final DoubleFunction<AttributeModifier> AM_FACTORY = amount -> new AttributeModifier(UUID.randomUUID(), "TACZ Melee Damage", amount, AttributeModifier.Operation.ADDITION);

    public ModernKineticGunItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public void bolt(ItemStack gunItem) {
        if (this.getCurrentAmmoCount(gunItem) > 0) {
            this.reduceCurrentAmmoCount(gunItem);
            this.setBulletInBarrel(gunItem, true);
        }
    }

    @Override
    public void shoot(ItemStack gunItem, Supplier<Float> pitch, Supplier<Float> yaw, boolean tracer, LivingEntity shooter) {
        ResourceLocation gunId = this.getGunId(gunItem);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return;
        }
        CommonGunIndex gunIndex = gunIndexOptional.get();
        BulletData bulletData = gunIndex.getBulletData();
        GunData gunData = gunIndex.getGunData();
        ResourceLocation ammoId = gunData.getAmmoId();
        FireMode fireMode = iGun.getFireMode(gunItem);
        AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity(shooter).getCacheProperty();
        if (cacheProperty == null) {
            return;
        }
        InaccuracyType inaccuracyType = InaccuracyType.getInaccuracyType(shooter);
        float inaccuracy = Math.max(0.0f, ((Float)((Map)cacheProperty.getCache("inaccuracy")).get((Object)inaccuracyType)).floatValue());
        if (inaccuracyType == InaccuracyType.AIM) {
            inaccuracy = Math.max(0.0f, ((Float)((Map)cacheProperty.getCache("aim_inaccuracy")).get((Object)inaccuracyType)).floatValue());
        }
        float finalInaccuracy = inaccuracy;
        Pair silence = (Pair)cacheProperty.getCache("silence");
        int soundDistance = (Integer)silence.first();
        boolean useSilenceSound = (Boolean)silence.right();
        float speed = ((Float)cacheProperty.getCache("ammo_speed")).floatValue();
        float finalSpeed = Mth.m_14036_((float)(speed / 20.0f), (float)0.0f, (float)Float.MAX_VALUE);
        int bulletAmount = Math.max(bulletData.getBulletAmount(), 1);
        int cycles = fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        boolean consumeAmmo = IGunOperator.fromLivingEntity(shooter).consumesAmmoOrNot();
        CycleTaskHelper.addCycleTask(() -> {
            boolean fire;
            if (shooter.m_21224_()) {
                return false;
            }
            if (consumeAmmo) {
                Bolt boltType = gunData.getBolt();
                boolean hasAmmoInBarrel = this.hasBulletInBarrel(gunItem) && boltType != Bolt.OPEN_BOLT;
                int ammoCount = this.getCurrentAmmoCount(gunItem) + (hasAmmoInBarrel ? 1 : 0);
                if (ammoCount <= 0) {
                    return false;
                }
            }
            boolean bl = fire = !MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent(shooter, gunItem, LogicalSide.SERVER));
            if (fire) {
                NetworkHandler.sendToTrackingEntity(new ServerMessageGunFire(shooter.m_19879_(), gunItem), (Entity)shooter);
                if (consumeAmmo) {
                    this.reduceAmmo(gunItem);
                }
                Level world = shooter.m_9236_();
                for (int i = 0; i < bulletAmount; ++i) {
                    this.doSpawnBulletEntity(world, shooter, gunItem, ((Float)pitch.get()).floatValue(), ((Float)yaw.get()).floatValue(), finalSpeed, finalInaccuracy, ammoId, gunId, tracer, gunData, bulletData);
                }
                if (soundDistance > 0) {
                    String soundId = useSilenceSound ? SoundManager.SILENCE_3P_SOUND : SoundManager.SHOOT_3P_SOUND;
                    SoundManager.sendSoundToNearby(shooter, soundDistance, gunId, soundId, 0.8f, 0.9f + shooter.m_217043_().m_188501_() * 0.125f);
                }
            }
            return true;
        }, period, cycles);
    }

    @Override
    public void melee(LivingEntity user, ItemStack gunItem) {
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            GunMeleeData meleeData = gunIndex.getGunData().getMeleeData();
            float distance = meleeData.getDistance();
            ResourceLocation muzzleId = this.getAttachmentId(gunItem, AttachmentType.MUZZLE);
            MeleeData muzzleData = this.getMeleeData(muzzleId);
            if (muzzleData != null) {
                this.doMelee(user, distance, muzzleData.getDistance(), muzzleData.getRangeAngle(), muzzleData.getKnockback(), muzzleData.getDamage(), muzzleData.getEffects());
                return;
            }
            ResourceLocation stockId = this.getAttachmentId(gunItem, AttachmentType.STOCK);
            MeleeData stockData = this.getMeleeData(stockId);
            if (stockData != null) {
                this.doMelee(user, distance, stockData.getDistance(), stockData.getRangeAngle(), stockData.getKnockback(), stockData.getDamage(), stockData.getEffects());
                return;
            }
            GunDefaultMeleeData defaultData = meleeData.getDefaultMeleeData();
            if (defaultData == null) {
                return;
            }
            this.doMelee(user, distance, defaultData.getDistance(), defaultData.getRangeAngle(), defaultData.getKnockback(), defaultData.getDamage(), Collections.emptyList());
        });
    }

    private void doMelee(LivingEntity user, float gunDistance, float meleeDistance, float rangeAngle, float knockback, float damage, List<EffectData> effects) {
        double distance = gunDistance + meleeDistance;
        float xRot = (float)Math.toRadians(-user.m_146909_());
        float yRot = (float)Math.toRadians(-user.m_146908_());
        Vec3 eyeVec = new Vec3(0.0, 0.0, 1.0).m_82496_(xRot).m_82524_(yRot).m_82541_().m_82490_(distance);
        Vec3 centrePos = user.m_146892_().m_82546_(eyeVec);
        List entityList = user.m_9236_().m_45976_(LivingEntity.class, user.m_20191_().m_82400_(distance));
        com.google.common.base.Supplier realDamage = Suppliers.memoize(() -> {
            AttributeInstance instance = user.m_21051_(Attributes.f_22281_);
            if (instance == null) {
                return Float.valueOf(damage);
            }
            double oldBase = instance.m_22115_();
            AttributeModifier modifier = AM_FACTORY.apply(damage);
            try {
                instance.m_22100_(0.0);
                instance.m_22118_(modifier);
                Float f = Float.valueOf((float)instance.m_22135_());
                return f;
            }
            finally {
                instance.m_22100_(oldBase);
                instance.m_22130_(modifier);
            }
        });
        for (LivingEntity living : entityList) {
            double degree;
            Vec3 targetVec = living.m_146892_().m_82546_(centrePos);
            double targetLength = targetVec.m_82553_();
            if (targetLength < distance || !((degree = Math.toDegrees(Math.acos(targetVec.m_82526_(eyeVec) / (targetLength * distance)))) < (double)(rangeAngle / 2.0f)) || !user.m_142582_((Entity)living)) continue;
            ModernKineticGunItem.doPerLivingHurt(user, living, knockback, ((Float)realDamage.get()).floatValue(), effects);
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.m_36399_(0.1f);
        }
        if (DebugCommand.DEBUG) {
            GunMeleeDebug.showRange(user, (int)Math.round(distance), centrePos, eyeVec, rangeAngle);
        }
    }

    private static void doPerLivingHurt(LivingEntity user, LivingEntity target, float knockback, float damage, List<EffectData> effects) {
        if (target.equals((Object)user)) {
            return;
        }
        target.m_147240_((double)knockback, (double)((float)Math.sin(Math.toRadians(user.m_146908_()))), (double)((float)(-Math.cos(Math.toRadians(user.m_146908_())))));
        if (user instanceof Player) {
            Player player = (Player)user;
            target.m_6469_(user.m_269291_().m_269075_(player), damage);
        } else {
            target.m_6469_(user.m_269291_().m_269333_(user), damage);
        }
        user.m_19970_(user, (Entity)target);
        if (!target.m_6084_()) {
            return;
        }
        for (EffectData effectData : effects) {
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectData.getEffectId());
            if (mobEffect == null) continue;
            int time = Math.max(0, effectData.getTime() * 20);
            int amplifier = Math.max(0, effectData.getAmplifier());
            MobEffectInstance effectInstance = new MobEffectInstance(mobEffect, time, amplifier, false, effectData.isHideParticles());
            target.m_7292_(effectInstance);
        }
        Level level = user.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int n = (int)((double)damage * 0.5);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), n, 0.1, 0.0, 0.1, 0.2);
        }
    }

    @Override
    public void fireSelect(ItemStack gunItem) {
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> {
            FireMode fireMode = this.getFireMode(gunItem);
            List<FireMode> fireModeSet = gunIndex.getGunData().getFireModeSet();
            int nextIndex = (fireModeSet.indexOf((Object)fireMode) + 1) % fireModeSet.size();
            FireMode nextFireMode = fireModeSet.get(nextIndex);
            this.setFireMode(gunItem, nextFireMode);
            return nextFireMode;
        });
    }

    protected void doSpawnBulletEntity(Level world, LivingEntity shooter, ItemStack gunItem, float pitch, float yaw, float speed, float inaccuracy, ResourceLocation ammoId, ResourceLocation gunId, boolean tracer, GunData gunData, BulletData bulletData) {
        EntityKineticBullet bullet = new EntityKineticBullet(world, shooter, gunItem, ammoId, gunId, tracer, gunData, bulletData);
        bullet.m_37251_((Entity)bullet, pitch, yaw, 0.0f, speed, inaccuracy);
        world.m_7967_((Entity)bullet);
    }

    @Override
    public int getLevel(int exp) {
        return 0;
    }

    @Override
    public int getExp(int level) {
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return 0;
    }

    protected void reduceAmmo(ItemStack currentGunItem) {
        Bolt boltType = TimelessAPI.getCommonGunIndex(this.getGunId(currentGunItem)).map(index -> index.getGunData().getBolt()).orElse(null);
        if (boltType == null) {
            return;
        }
        if (boltType == Bolt.MANUAL_ACTION) {
            this.setBulletInBarrel(currentGunItem, false);
        } else if (boltType == Bolt.CLOSED_BOLT) {
            if (this.getCurrentAmmoCount(currentGunItem) > 0) {
                this.reduceCurrentAmmoCount(currentGunItem);
            } else {
                this.setBulletInBarrel(currentGunItem, false);
            }
        } else {
            this.reduceCurrentAmmoCount(currentGunItem);
        }
    }

    @Nullable
    private MeleeData getMeleeData(ResourceLocation attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

