/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LivingEntityCrawl {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;

    public LivingEntityCrawl(LivingEntity shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void crawl(boolean isCrawl) {
        this.data.isCrawling = isCrawl;
    }

    public void tickCrawling() {
        Item item;
        if (this.data.currentGunItem == null || !((item = this.data.currentGunItem.get().m_41720_()) instanceof IGun)) {
            this.data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        IGun iGun = (IGun)item;
        ItemStack currentGunItem = this.data.currentGunItem.get();
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        if (TimelessAPI.getCommonGunIndex(gunId).isEmpty()) {
            this.data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        if (this.shooter.m_5833_() || this.shooter.m_20159_() || this.shooter.f_20899_ || this.shooter.m_6069_() || !this.shooter.m_20096_()) {
            this.data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        this.setCrawlPose();
    }

    private void setCrawlPose() {
        if (this.data.isCrawling) {
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.setForcedPose(Pose.SWIMMING);
            } else {
                this.shooter.m_20124_(Pose.SWIMMING);
            }
        } else {
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.setForcedPose(null);
            }
        }
    }
}

