/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.loader.asset;

import com.mojang.blaze3d.audio.OggAudioStream;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class SoundLoader {
    private static final Marker MARKER = MarkerManager.getMarker((String)"SoundLoader");
    private static final Pattern SOUND_PATTERN = Pattern.compile("^(\\w+)/sounds/([\\w/]+)\\.ogg$");

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = SOUND_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            String namespace = matcher.group(1);
            String path = matcher.group(2);
            ZipEntry entry = zipFile.getEntry(zipPath);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                return false;
            }
            try (InputStream zipEntryStream = zipFile.getInputStream(entry);){
                boolean bl;
                try (OggAudioStream audioStream = new OggAudioStream(zipEntryStream);){
                    ByteBuffer bytebuffer = audioStream.m_83764_();
                    ResourceLocation registryName = new ResourceLocation(namespace, path);
                    ClientAssetManager.INSTANCE.putSoundBuffer(registryName, new SoundBuffer(bytebuffer, audioStream.m_6206_()));
                    bl = true;
                }
                return bl;
            }
            catch (IOException ioe) {
                GunMod.LOGGER.warn(MARKER, "Failed to load sound: {}", (Object)zipPath);
                ioe.printStackTrace();
            }
        }
        return false;
    }

    public static void load(File root) {
        Path filePath = root.toPath().resolve("sounds");
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".ogg", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                     OggAudioStream audioStream = new OggAudioStream(stream);){
                    ByteBuffer bytebuffer = audioStream.m_83764_();
                    ClientAssetManager.INSTANCE.putSoundBuffer((ResourceLocation)id, new SoundBuffer(bytebuffer, audioStream.m_6206_()));
                }
                catch (IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read sound file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(filePath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)filePath);
                e.printStackTrace();
            }
        }
    }
}

