/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoDisplay;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoEntityDisplay;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoParticle;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoTransform;
import com.tacz.guns.client.resource.pojo.display.ammo.ShellDisplay;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.resource.pojo.AmmoIndexPOJO;
import com.tacz.guns.util.ColorHex;
import java.util.Objects;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientAmmoIndex {
    private String name;
    @Nullable
    private BedrockAmmoModel ammoModel;
    @Nullable
    private ResourceLocation modelTextureLocation;
    private ResourceLocation slotTextureLocation;
    @Nullable
    private BedrockAmmoModel ammoEntityModel;
    @Nullable
    private ResourceLocation ammoEntityTextureLocation;
    @Nullable
    private BedrockAmmoModel shellModel;
    @Nullable
    private ResourceLocation shellTextureLocation;
    private int stackSize;
    @Nullable
    private AmmoParticle particle;
    private float[] tracerColor = new float[]{1.0f, 1.0f, 1.0f};
    private AmmoTransform transform;
    @Nullable
    private String tooltipKey;

    private ClientAmmoIndex() {
    }

    public static ClientAmmoIndex getInstance(AmmoIndexPOJO clientPojo) throws IllegalArgumentException {
        ClientAmmoIndex index = new ClientAmmoIndex();
        ClientAmmoIndex.checkIndex(clientPojo, index);
        AmmoDisplay display = ClientAmmoIndex.checkDisplay(clientPojo);
        ClientAmmoIndex.checkName(clientPojo, index);
        ClientAmmoIndex.checkTextureAndModel(display, index);
        ClientAmmoIndex.checkSlotTexture(display, index);
        ClientAmmoIndex.checkStackSize(clientPojo, index);
        ClientAmmoIndex.checkAmmoEntity(display, index);
        ClientAmmoIndex.checkShell(display, index);
        ClientAmmoIndex.checkParticle(display, index);
        ClientAmmoIndex.checkTracerColor(display, index);
        ClientAmmoIndex.checkTransform(display, index);
        return index;
    }

    private static void checkIndex(AmmoIndexPOJO ammoIndexPOJO, ClientAmmoIndex index) {
        Preconditions.checkArgument((ammoIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        index.tooltipKey = ammoIndexPOJO.getTooltip();
    }

    private static void checkName(AmmoIndexPOJO ammoIndexPOJO, ClientAmmoIndex index) {
        index.name = ammoIndexPOJO.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.tacz.error.no_name";
        }
    }

    @NotNull
    private static AmmoDisplay checkDisplay(AmmoIndexPOJO ammoIndexPOJO) {
        ResourceLocation pojoDisplay = ammoIndexPOJO.getDisplay();
        Preconditions.checkArgument((pojoDisplay != null ? 1 : 0) != 0, (Object)"index object missing display field");
        AmmoDisplay display = ClientAssetManager.INSTANCE.getAmmoDisplay(pojoDisplay);
        Preconditions.checkArgument((display != null ? 1 : 0) != 0, (Object)"there is no corresponding display file");
        return display;
    }

    private static void checkTextureAndModel(AmmoDisplay display, ClientAmmoIndex index) {
        ResourceLocation modelLocation = display.getModelLocation();
        if (modelLocation == null) {
            return;
        }
        BedrockModelPOJO modelPOJO = ClientAssetManager.INSTANCE.getModels(modelLocation);
        Preconditions.checkArgument((modelPOJO != null ? 1 : 0) != 0, (Object)"there is no corresponding model file");
        index.modelTextureLocation = display.getModelTexture();
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            index.ammoModel = new BedrockAmmoModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            index.ammoModel = new BedrockAmmoModel(modelPOJO, BedrockVersion.NEW);
        }
    }

    private static void checkSlotTexture(AmmoDisplay display, ClientAmmoIndex index) {
        index.slotTextureLocation = Objects.requireNonNullElseGet(display.getSlotTextureLocation(), MissingTextureAtlasSprite::m_118071_);
    }

    private static void checkAmmoEntity(AmmoDisplay display, ClientAmmoIndex index) {
        AmmoEntityDisplay ammoEntity = display.getAmmoEntity();
        if (ammoEntity != null && ammoEntity.getModelLocation() != null && ammoEntity.getModelTexture() != null) {
            index.ammoEntityTextureLocation = ammoEntity.getModelTexture();
            ResourceLocation modelLocation = ammoEntity.getModelLocation();
            BedrockModelPOJO modelPOJO = ClientAssetManager.INSTANCE.getModels(modelLocation);
            if (modelPOJO == null) {
                return;
            }
            if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
                index.ammoEntityModel = new BedrockAmmoModel(modelPOJO, BedrockVersion.LEGACY);
            }
            if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
                index.ammoEntityModel = new BedrockAmmoModel(modelPOJO, BedrockVersion.NEW);
            }
        }
    }

    private static void checkShell(AmmoDisplay display, ClientAmmoIndex index) {
        ShellDisplay shellDisplay = display.getShellDisplay();
        if (shellDisplay != null && shellDisplay.getModelLocation() != null && shellDisplay.getModelTexture() != null) {
            index.shellTextureLocation = shellDisplay.getModelTexture();
            ResourceLocation modelLocation = shellDisplay.getModelLocation();
            BedrockModelPOJO modelPOJO = ClientAssetManager.INSTANCE.getModels(modelLocation);
            if (modelPOJO == null) {
                return;
            }
            if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
                index.shellModel = new BedrockAmmoModel(modelPOJO, BedrockVersion.LEGACY);
            }
            if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
                index.shellModel = new BedrockAmmoModel(modelPOJO, BedrockVersion.NEW);
            }
        }
    }

    private static void checkParticle(AmmoDisplay display, ClientAmmoIndex index) {
        if (display.getParticle() != null) {
            try {
                AmmoParticle particle = display.getParticle();
                String name = particle.getName();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[0])) {
                    particle.setParticleOptions(ParticleArgument.m_247456_((StringReader)new StringReader(name), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
                    Preconditions.checkArgument((particle.getCount() > 0 ? 1 : 0) != 0, (Object)"particle count must be greater than 0");
                    Preconditions.checkArgument((particle.getLifeTime() > 0 ? 1 : 0) != 0, (Object)"particle life time must be greater than 0");
                    index.particle = particle;
                }
            }
            catch (CommandSyntaxException e) {
                e.fillInStackTrace();
            }
        }
    }

    private static void checkTracerColor(AmmoDisplay display, ClientAmmoIndex index) {
        String tracerColorText = display.getTracerColor();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tracerColorText})) {
            index.tracerColor = ColorHex.colorTextToRbgFloatArray(tracerColorText);
        }
    }

    private static void checkTransform(AmmoDisplay display, ClientAmmoIndex index) {
        AmmoTransform readTransform = display.getTransform();
        index.transform = readTransform == null || readTransform.getScale() == null ? AmmoTransform.getDefault() : display.getTransform();
    }

    private static void checkStackSize(AmmoIndexPOJO clientPojo, ClientAmmoIndex index) {
        index.stackSize = Math.max(clientPojo.getStackSize(), 1);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTooltipKey() {
        return this.tooltipKey;
    }

    @Nullable
    public BedrockAmmoModel getAmmoModel() {
        return this.ammoModel;
    }

    @Nullable
    public ResourceLocation getModelTextureLocation() {
        return this.modelTextureLocation;
    }

    public ResourceLocation getSlotTextureLocation() {
        return this.slotTextureLocation;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    @Nullable
    public BedrockAmmoModel getAmmoEntityModel() {
        return this.ammoEntityModel;
    }

    @Nullable
    public ResourceLocation getAmmoEntityTextureLocation() {
        return this.ammoEntityTextureLocation;
    }

    @Nullable
    public BedrockAmmoModel getShellModel() {
        return this.shellModel;
    }

    @Nullable
    public ResourceLocation getShellTextureLocation() {
        return this.shellTextureLocation;
    }

    @Nullable
    public AmmoParticle getParticle() {
        return this.particle;
    }

    public float[] getTracerColor() {
        return this.tracerColor;
    }

    public AmmoTransform getTransform() {
        return this.transform;
    }
}

