/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.resource.pojo.display.gun.ShellEjection;
import com.tacz.guns.compat.oculus.OculusCompat;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class ShellRender
implements IFunctionalRenderer {
    private static final ConcurrentLinkedDeque<Data> SHELL_QUEUE = new ConcurrentLinkedDeque();
    public static boolean isSelf = false;
    private final BedrockGunModel bedrockGunModel;

    public ShellRender(BedrockGunModel bedrockGunModel) {
        this.bedrockGunModel = bedrockGunModel;
    }

    public static void addShell(Vector3f randomVelocity) {
        double xRandom = Math.random() * (double)randomVelocity.x();
        double yRandom = Math.random() * (double)randomVelocity.y();
        double zRandom = Math.random() * (double)randomVelocity.z();
        Vector3f vector3f = new Vector3f((float)xRandom, (float)yRandom, (float)zRandom);
        SHELL_QUEUE.offerLast(new Data(System.currentTimeMillis(), vector3f));
    }

    public static void renderShell(ResourceLocation gunId, PoseStack poseStack, BedrockGunModel gunModel) {
        TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> {
            ShellEjection shellEjection = index.getShellEjection();
            if (shellEjection == null) {
                SHELL_QUEUE.clear();
                return;
            }
            TimelessAPI.getClientAmmoIndex(index.getGunData().getAmmoId()).ifPresent(ammoIndex -> {
                BedrockAmmoModel model = ammoIndex.getShellModel();
                if (model == null) {
                    return;
                }
                ResourceLocation location = ammoIndex.getShellTextureLocation();
                if (location == null) {
                    return;
                }
                long lifeTime = (long)(shellEjection.getLivingTime() * 1000.0f);
                ShellRender.checkShellQueue(lifeTime);
                Vector3f initialVelocity = shellEjection.getInitialVelocity();
                Vector3f acceleration = shellEjection.getAcceleration();
                Vector3f angularVelocity = shellEjection.getAngularVelocity();
                for (Data data : SHELL_QUEUE) {
                    if (data.normal != null || data.pose != null) continue;
                    data.normal = new Matrix3f((Matrix3fc)poseStack.m_85850_().m_252943_());
                    data.pose = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
                }
                gunModel.delegateRender((poseStack1, vertexConsumer1, transformType1, light, overlay) -> SHELL_QUEUE.forEach(data -> ShellRender.renderSingleShell(transformType1, light, overlay, data, initialVelocity, acceleration, angularVelocity, model, location)));
            });
        });
    }

    private static void renderSingleShell(ItemDisplayContext transformType1, int light, int overlay, Data data, Vector3f initialVelocity, Vector3f acceleration, Vector3f angularVelocity, BedrockAmmoModel model, ResourceLocation location) {
        if (data.normal == null && data.pose == null) {
            return;
        }
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_85850_().m_252943_().mul((Matrix3fc)data.normal);
        poseStack2.m_85850_().m_252922_().mul((Matrix4fc)data.pose);
        long remindTime = System.currentTimeMillis() - data.timeStamp;
        double time = (double)remindTime / 1000.0;
        Vector3f randomOffset = data.randomOffset;
        double x = (double)(initialVelocity.x() + randomOffset.x()) * time + 0.5 * (double)acceleration.x() * time * time;
        double y = (double)(initialVelocity.y() + randomOffset.y()) * time + 0.5 * (double)acceleration.y() * time * time;
        double z = (double)(initialVelocity.z() + randomOffset.z()) * time + 0.5 * (double)acceleration.z() * time * time;
        poseStack2.m_85837_(-x, -y, z);
        double xw = time * (double)angularVelocity.x();
        double yw = time * (double)angularVelocity.y();
        double zw = time * (double)angularVelocity.z();
        poseStack2.m_252781_(Axis.f_252495_.m_252977_((float)xw));
        poseStack2.m_252781_(Axis.f_252392_.m_252977_((float)yw));
        poseStack2.m_252781_(Axis.f_252403_.m_252977_((float)zw));
        poseStack2.m_85837_(0.0, -1.5, 0.0);
        model.render(poseStack2, transformType1, RenderType.m_110452_((ResourceLocation)location), light, overlay);
    }

    private static void checkShellQueue(long lifeTime) {
        if (!SHELL_QUEUE.isEmpty()) {
            Data data = SHELL_QUEUE.peekFirst();
            if (System.currentTimeMillis() - data.timeStamp > lifeTime) {
                SHELL_QUEUE.pollFirst();
                ShellRender.checkShellQueue(lifeTime);
            }
        }
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexBuffer, ItemDisplayContext transformType, int light, int overlay) {
        if (OculusCompat.isRenderShadow()) {
            return;
        }
        if (!isSelf) {
            return;
        }
        ItemStack currentGunItem = this.bedrockGunModel.getCurrentGunItem();
        IGun iGun = IGun.getIGunOrNull(currentGunItem);
        if (iGun == null) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        ShellRender.renderShell(gunId, poseStack, this.bedrockGunModel);
    }

    public static class Data {
        public final long timeStamp;
        public final Vector3f randomOffset;
        public Matrix3f normal = null;
        public Matrix4f pose = null;

        public Data(long timeStamp, Vector3f randomOffset) {
            this.timeStamp = timeStamp;
            this.randomOffset = randomOffset;
        }
    }
}

