/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation.statemachine;

import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.DiscreteTrackArray;
import com.tacz.guns.api.client.animation.ObjectAnimationRunner;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AnimationStateContext {
    @Nullable
    private AnimationStateMachine<?> stateMachine;

    @Nullable
    public AnimationStateMachine<?> getStateMachine() {
        return this.stateMachine;
    }

    public DiscreteTrackArray getTrackArray() {
        if (this.stateMachine == null) {
            throw new IllegalStateException("This context has not been bound to a statemachine yet.");
        }
        return (DiscreteTrackArray)this.stateMachine.getAnimationController().getUpdatingTrackArray();
    }

    public int addTrackLine() {
        return this.getTrackArray().addTrackLine();
    }

    public int assignNewTrack(int index) {
        return this.getTrackArray().assignNewTrack(index);
    }

    public int findIdleTrack(int index, boolean interruptHolding) {
        List<Integer> trackList = this.getTrackArray().getByIndex(index);
        if (this.stateMachine == null) {
            return -1;
        }
        AnimationController controller = this.stateMachine.getAnimationController();
        for (int track : trackList) {
            ObjectAnimationRunner animation = controller.getAnimation(track);
            if (animation != null && !animation.isStopped() && (!interruptHolding || !animation.isHolding())) continue;
            return track;
        }
        return this.assignNewTrack(index);
    }

    void setStateMachine(@Nullable AnimationStateMachine<?> stateMachine) {
        if (this.stateMachine != null) {
            this.stateMachine.getAnimationController().setUpdatingTrackArray(null);
        }
        this.stateMachine = stateMachine;
        if (stateMachine != null) {
            stateMachine.getAnimationController().setUpdatingTrackArray(new DiscreteTrackArray());
        }
    }
}

