/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BearingRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T> {
    public BearingRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(T be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        Direction facing = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        PartialModel top = ((IBearingBlockEntity)be).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        SuperByteBuffer superBuffer = CachedBufferer.partial(top, be.m_58900_());
        float interpolatedAngle = ((IBearingBlockEntity)be).getInterpolatedAngle(partialTicks - 1.0f);
        BearingRenderer.kineticRotationTransform(superBuffer, be, facing.m_122434_(), (float)((double)(interpolatedAngle / 180.0f) * Math.PI), light);
        if (facing.m_122434_().m_122479_()) {
            superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing.m_122424_())));
        }
        superBuffer.rotateCentered(Direction.EAST, AngleHelper.rad(-90.0f - AngleHelper.verticalAngle(facing)));
        superBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be, BlockState state) {
        return CachedBufferer.partialFacing(AllPartialModels.SHAFT_HALF, state, ((Direction)state.m_61143_((Property)BearingBlock.FACING)).m_122424_());
    }
}

