/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.event.MaidAreaRenderEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncMaidAreaMessage {
    private final int id;
    private final SchedulePos schedulePos;

    public SyncMaidAreaMessage(int id, SchedulePos schedulePos) {
        this.id = id;
        this.schedulePos = schedulePos;
    }

    public static void encode(SyncMaidAreaMessage message, FriendlyByteBuf buf) {
        SchedulePos pos = message.schedulePos;
        buf.m_130130_(message.id);
        buf.m_130064_(pos.getWorkPos());
        buf.m_130064_(pos.getIdlePos());
        buf.m_130064_(pos.getSleepPos());
        buf.m_130085_(pos.getDimension());
    }

    public static SyncMaidAreaMessage decode(FriendlyByteBuf buf) {
        int maidId = buf.m_130242_();
        BlockPos workPos = buf.m_130135_();
        BlockPos idlePos = buf.m_130135_();
        BlockPos sleepPos = buf.m_130135_();
        ResourceLocation dimension = buf.m_130281_();
        SchedulePos pos = new SchedulePos(workPos, idlePos, sleepPos, dimension);
        return new SyncMaidAreaMessage(maidId, pos);
    }

    public static void handle(SyncMaidAreaMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SyncMaidAreaMessage.writePos(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void writePos(SyncMaidAreaMessage message) {
        MaidAreaRenderEvent.addSchedulePos(message.id, message.schedulePos);
    }
}

