/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ChairModelMessage {
    private final int id;
    private final ResourceLocation modelId;
    private final float mountedHeight;
    private final boolean tameableCanRide;
    private final boolean noGravity;

    public ChairModelMessage(int id, ResourceLocation modelId, float mountedHeight, boolean tameableCanRide, boolean noGravity) {
        this.id = id;
        this.modelId = modelId;
        this.mountedHeight = mountedHeight;
        this.tameableCanRide = tameableCanRide;
        this.noGravity = noGravity;
    }

    public static void encode(ChairModelMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130085_(message.modelId);
        buf.writeFloat(message.mountedHeight);
        buf.writeBoolean(message.tameableCanRide);
        buf.writeBoolean(message.noGravity);
    }

    public static ChairModelMessage decode(FriendlyByteBuf buf) {
        return new ChairModelMessage(buf.readInt(), buf.m_130281_(), buf.readFloat(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(ChairModelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                boolean canChangeModel;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                boolean bl = canChangeModel = (Boolean)ChairConfig.CHAIR_CHANGE_MODEL.get() != false || sender.m_7500_();
                if (entity instanceof EntityChair) {
                    if (canChangeModel) {
                        EntityChair chair = (EntityChair)entity;
                        chair.setModelId(message.modelId.toString());
                        chair.setMountedHeight(message.mountedHeight);
                        chair.setTameableCanRide(message.tameableCanRide);
                        chair.m_20242_(message.noGravity);
                        if (!message.tameableCanRide && !chair.m_20197_().isEmpty()) {
                            chair.m_20153_();
                        }
                    } else if (sender.m_6084_()) {
                        sender.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.change_model.disabled"));
                    }
                }
            });
        }
    }
}

