/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractStoreMaidItem
extends Item {
    static final String MAID_INFO = "MaidInfo";
    static final String CUSTOM_NAME = "CustomName";

    public AbstractStoreMaidItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasMaidData(ItemStack stack) {
        return stack.m_41782_() && !Objects.requireNonNull(stack.m_41783_()).m_128469_(MAID_INFO).m_128456_();
    }

    public static CompoundTag getMaidData(ItemStack stack) {
        if (AbstractStoreMaidItem.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.m_41783_()).m_128469_(MAID_INFO);
        }
        return new CompoundTag();
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.m_142038_()) {
            entity.m_146915_(true);
        }
        if (!entity.m_20147_()) {
            entity.m_20331_(true);
        }
        Vec3 position = entity.m_20182_();
        int minY = entity.f_19853_.m_141937_();
        if (position.f_82480_ < (double)minY) {
            entity.m_20242_(true);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6034_(position.f_82479_, (double)minY, position.f_82481_);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CompoundTag maidData = AbstractStoreMaidItem.getMaidData(stack);
        if (maidData.m_128425_("ModelId", 8)) {
            String modelId = maidData.m_128461_("ModelId");
            String customName = "";
            if (maidData.m_128425_(CUSTOM_NAME, 8)) {
                customName = maidData.m_128461_(CUSTOM_NAME);
            }
            return Optional.of(new ItemMaidTooltip(modelId, customName));
        }
        return Optional.empty();
    }
}

