/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.ConstantValue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.easing.EasingType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.CustomInstructionKeyframeEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.KeyframeEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.ParticleKeyFrameEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.SoundKeyframeEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.AnimationPoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimationQueue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.EventKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.KeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.KeyFrameLocation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.ParticleEventKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.VectorKeyFrameList;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneTopLevelSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Axis;
import com.github.tartaricacid.touhoulittlemaid.mclib.math.IValue;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationController<T extends AnimatableEntity<?>> {
    private final String name;
    private final Object2ObjectOpenHashMap<String, BoneAnimationQueue> boneAnimationQueues = new Object2ObjectOpenHashMap();
    private final ReferenceArrayList<BoneAnimationQueue> activeBoneAnimationQueues = new ReferenceArrayList();
    private final Set<EventKeyFrame<?>> executedKeyFrames = new ReferenceOpenHashSet();
    public double transitionLengthTicks;
    public boolean isJustStarting = false;
    public double tickOffset;
    public Double2DoubleFunction customEasingMethod;
    public double animationSpeed = 1.0;
    public EasingType easingType = EasingType.NONE;
    public boolean shouldResetTick = false;
    protected T animatable;
    protected IAnimationPredicate<T> animationPredicate;
    protected AnimationState animationState = AnimationState.STOPPED;
    protected Queue<Pair<ILoopType, Animation>> animationQueue = new LinkedList<Pair<ILoopType, Animation>>();
    protected Animation currentAnimation;
    protected ILoopType currentAnimationLoop;
    protected AnimationBuilder currentAnimationBuilder = new AnimationBuilder();
    protected boolean justStartedTransition = false;
    protected boolean needsAnimationReload = false;
    private ISoundListener<T> soundListener;
    private IParticleListener<T> particleListener;
    private ICustomInstructionListener<T> customInstructionListener;
    private boolean justStopped = false;

    public AnimationController(T animatable, String name, float transitionLengthTicks, IAnimationPredicate<T> animationPredicate) {
        this.animatable = animatable;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.animationPredicate = animationPredicate;
        this.tickOffset = 0.0;
    }

    public AnimationController(T animatable, String name, float transitionLengthTicks, EasingType easingtype, IAnimationPredicate<T> animationPredicate) {
        this.animatable = animatable;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.easingType = easingtype;
        this.animationPredicate = animationPredicate;
        this.tickOffset = 0.0;
    }

    public AnimationController(T animatable, String name, float transitionLengthTicks, Double2DoubleFunction customEasingMethod, IAnimationPredicate<T> animationPredicate) {
        this.animatable = animatable;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.customEasingMethod = customEasingMethod;
        this.easingType = EasingType.CUSTOM;
        this.animationPredicate = animationPredicate;
        this.tickOffset = 0.0;
    }

    public void setAnimation(AnimationBuilder builder) {
        if (builder == null || builder.getRawAnimationList().isEmpty()) {
            this.animationState = AnimationState.STOPPED;
        } else if (!builder.getRawAnimationList().equals(this.currentAnimationBuilder.getRawAnimationList()) || this.needsAnimationReload) {
            AtomicBoolean encounteredError = new AtomicBoolean(false);
            LinkedList animations = builder.getRawAnimationList().stream().map(rawAnimation -> {
                Animation animation = ((AnimatableEntity)this.animatable).getAnimation(rawAnimation.animationName);
                if (animation == null) {
                    TouhouLittleMaid.LOGGER.warn("Could not load animation: {}. Is it missing?", (Object)rawAnimation.animationName);
                    encounteredError.set(true);
                    return null;
                }
                ILoopType loopType = animation.loop;
                if (rawAnimation.loopType != null) {
                    loopType = rawAnimation.loopType;
                }
                return Pair.of((Object)loopType, (Object)animation);
            }).collect(Collectors.toCollection(LinkedList::new));
            if (encounteredError.get()) {
                return;
            }
            this.animationQueue = animations;
            this.currentAnimationBuilder = builder;
            this.shouldResetTick = true;
            this.animationState = AnimationState.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
        }
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Animation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public List<BoneAnimationQueue> getBoneAnimationQueues() {
        return this.activeBoneAnimationQueues;
    }

    public void registerSoundListener(ISoundListener<T> soundListener) {
        this.soundListener = soundListener;
    }

    public void registerParticleListener(IParticleListener<T> particleListener) {
        this.particleListener = particleListener;
    }

    public void registerCustomInstructionListener(ICustomInstructionListener<T> customInstructionListener) {
        this.customInstructionListener = customInstructionListener;
    }

    public void process(double tick, AnimationEvent<T> event, Map<String, BoneTopLevelSnapshot> modelRendererList, MolangParser parser, boolean modelDirty) {
        Animation animation;
        parser.setValue("query.life_time", () -> tick / 20.0);
        if (this.currentAnimation != null && (animation = ((AnimatableEntity)this.animatable).getAnimation(this.currentAnimation.animationName)) != null) {
            this.currentAnimation = animation;
        }
        if (modelDirty) {
            this.switchRenderer(modelRendererList);
            if (this.currentAnimation != null) {
                this.switchAnimation();
            }
        }
        double adjustedTick = this.adjustTick(tick);
        if (this.animationState == AnimationState.TRANSITIONING && adjustedTick >= this.transitionLengthTicks) {
            this.shouldResetTick = true;
            this.animationState = AnimationState.RUNNING;
            adjustedTick = this.adjustTick(tick);
        }
        assert (adjustedTick >= 0.0) : "GeckoLib: Tick was less than zero";
        PlayState playState = this.testAnimationPredicate(event);
        if (playState == PlayState.STOP || this.currentAnimation == null && this.animationQueue.isEmpty()) {
            this.animationState = AnimationState.STOPPED;
            this.justStopped = true;
            return;
        }
        if (this.justStartedTransition && (this.shouldResetTick || this.justStopped)) {
            this.justStopped = false;
            adjustedTick = this.adjustTick(tick);
        } else if (this.currentAnimation == null && !this.animationQueue.isEmpty()) {
            this.shouldResetTick = true;
            this.animationState = AnimationState.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
            adjustedTick = this.adjustTick(tick);
        } else if (this.animationState != AnimationState.TRANSITIONING) {
            this.animationState = AnimationState.RUNNING;
        }
        if (this.animationState == AnimationState.TRANSITIONING) {
            if (adjustedTick == 0.0 || this.isJustStarting) {
                this.justStartedTransition = false;
                Pair<ILoopType, Animation> current = this.animationQueue.poll();
                if (current != null) {
                    this.currentAnimationLoop = (ILoopType)current.getLeft();
                    this.currentAnimation = (Animation)current.getRight();
                    this.resetEventKeyFrames();
                    this.switchAnimation();
                } else {
                    this.currentAnimation = null;
                }
            }
            if (this.currentAnimation != null) {
                this.setAnimTime(parser, 0.0);
                for (BoneAnimationQueue boneAnimationQueue : this.activeBoneAnimationQueues) {
                    BoneAnimation boneAnimation = boneAnimationQueue.animation;
                    if (boneAnimation == null) continue;
                    BoneSnapshot boneSnapshot = boneAnimationQueue.snapshot();
                    BoneSnapshot initialSnapshot = boneAnimationQueue.topLevelSnapshot.bone.getInitialSnapshot();
                    VectorKeyFrameList<KeyFrame<IValue>> rotationKeyFrames = boneAnimation.rotationKeyFrames;
                    if (!rotationKeyFrames.xKeyFrames.isEmpty()) {
                        AnimationPoint xPoint = this.getAnimationPointAtTick(rotationKeyFrames.xKeyFrames, 0.0, true, Axis.X);
                        AnimationPoint yPoint = this.getAnimationPointAtTick(rotationKeyFrames.yKeyFrames, 0.0, true, Axis.Y);
                        AnimationPoint zPoint = this.getAnimationPointAtTick(rotationKeyFrames.zKeyFrames, 0.0, true, Axis.Z);
                        boneAnimationQueue.rotationXQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.rotationValueX - initialSnapshot.rotationValueX, xPoint.animationStartValue));
                        boneAnimationQueue.rotationYQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.rotationValueY - initialSnapshot.rotationValueY, yPoint.animationStartValue));
                        boneAnimationQueue.rotationZQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.rotationValueZ - initialSnapshot.rotationValueZ, zPoint.animationStartValue));
                    }
                    VectorKeyFrameList<KeyFrame<IValue>> positionKeyFrames = boneAnimation.positionKeyFrames;
                    if (!positionKeyFrames.xKeyFrames.isEmpty()) {
                        AnimationPoint xPoint = this.getAnimationPointAtTick(positionKeyFrames.xKeyFrames, 0.0, false, Axis.X);
                        AnimationPoint yPoint = this.getAnimationPointAtTick(positionKeyFrames.yKeyFrames, 0.0, false, Axis.Y);
                        AnimationPoint zPoint = this.getAnimationPointAtTick(positionKeyFrames.zKeyFrames, 0.0, false, Axis.Z);
                        boneAnimationQueue.positionXQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.positionOffsetX, xPoint.animationStartValue));
                        boneAnimationQueue.positionYQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.positionOffsetY, yPoint.animationStartValue));
                        boneAnimationQueue.positionZQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.positionOffsetZ, zPoint.animationStartValue));
                    }
                    VectorKeyFrameList<KeyFrame<IValue>> scaleKeyFrames = boneAnimation.scaleKeyFrames;
                    if (scaleKeyFrames.xKeyFrames.isEmpty()) continue;
                    AnimationPoint xPoint = this.getAnimationPointAtTick(scaleKeyFrames.xKeyFrames, 0.0, false, Axis.X);
                    AnimationPoint yPoint = this.getAnimationPointAtTick(scaleKeyFrames.yKeyFrames, 0.0, false, Axis.Y);
                    AnimationPoint zPoint = this.getAnimationPointAtTick(scaleKeyFrames.zKeyFrames, 0.0, false, Axis.Z);
                    boneAnimationQueue.scaleXQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.scaleValueX, xPoint.animationStartValue));
                    boneAnimationQueue.scaleYQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.scaleValueY, yPoint.animationStartValue));
                    boneAnimationQueue.scaleZQueue().add(new AnimationPoint(null, adjustedTick, this.transitionLengthTicks, boneSnapshot.scaleValueZ, zPoint.animationStartValue));
                }
            }
        } else if (this.getAnimationState() == AnimationState.RUNNING) {
            this.resetQueues();
            this.processCurrentAnimation(adjustedTick, tick, parser);
        }
    }

    private void setAnimTime(MolangParser parser, double tick) {
        parser.setValue("query.anim_time", () -> tick / 20.0);
    }

    protected PlayState testAnimationPredicate(AnimationEvent<T> event) {
        return this.animationPredicate.test(event);
    }

    private void processCurrentAnimation(double tick, double actualTick, MolangParser parser) {
        KeyframeEvent event;
        assert (this.currentAnimation != null);
        if (tick >= this.currentAnimation.animationLength) {
            if (!this.currentAnimationLoop.isRepeatingAfterEnd()) {
                Pair<ILoopType, Animation> peek = this.animationQueue.peek();
                if (peek == null) {
                    this.animationState = AnimationState.STOPPED;
                    return;
                }
                this.animationState = AnimationState.TRANSITIONING;
                this.shouldResetTick = true;
                this.currentAnimation = (Animation)peek.getRight();
                this.currentAnimationLoop = (ILoopType)peek.getLeft();
            } else {
                this.shouldResetTick = true;
                tick = this.adjustTick(actualTick);
                this.resetEventKeyFrames();
            }
        }
        this.setAnimTime(parser, tick);
        for (BoneAnimationQueue boneAnimationQueue : this.activeBoneAnimationQueues) {
            BoneAnimation boneAnimation = boneAnimationQueue.animation;
            VectorKeyFrameList<KeyFrame<IValue>> rotationKeyFrames = boneAnimation.rotationKeyFrames;
            VectorKeyFrameList<KeyFrame<IValue>> positionKeyFrames = boneAnimation.positionKeyFrames;
            VectorKeyFrameList<KeyFrame<IValue>> scaleKeyFrames = boneAnimation.scaleKeyFrames;
            if (!rotationKeyFrames.xKeyFrames.isEmpty()) {
                boneAnimationQueue.rotationXQueue().add(this.getAnimationPointAtTick(rotationKeyFrames.xKeyFrames, tick, true, Axis.X));
                boneAnimationQueue.rotationYQueue().add(this.getAnimationPointAtTick(rotationKeyFrames.yKeyFrames, tick, true, Axis.Y));
                boneAnimationQueue.rotationZQueue().add(this.getAnimationPointAtTick(rotationKeyFrames.zKeyFrames, tick, true, Axis.Z));
            }
            if (!positionKeyFrames.xKeyFrames.isEmpty()) {
                boneAnimationQueue.positionXQueue().add(this.getAnimationPointAtTick(positionKeyFrames.xKeyFrames, tick, false, Axis.X));
                boneAnimationQueue.positionYQueue().add(this.getAnimationPointAtTick(positionKeyFrames.yKeyFrames, tick, false, Axis.Y));
                boneAnimationQueue.positionZQueue().add(this.getAnimationPointAtTick(positionKeyFrames.zKeyFrames, tick, false, Axis.Z));
            }
            if (scaleKeyFrames.xKeyFrames.isEmpty()) continue;
            boneAnimationQueue.scaleXQueue().add(this.getAnimationPointAtTick(scaleKeyFrames.xKeyFrames, tick, false, Axis.X));
            boneAnimationQueue.scaleYQueue().add(this.getAnimationPointAtTick(scaleKeyFrames.yKeyFrames, tick, false, Axis.Y));
            boneAnimationQueue.scaleZQueue().add(this.getAnimationPointAtTick(scaleKeyFrames.zKeyFrames, tick, false, Axis.Z));
        }
        if (this.soundListener != null) {
            for (EventKeyFrame soundKeyFrame : this.currentAnimation.soundKeyFrames) {
                if (!(tick >= soundKeyFrame.getStartTick()) || !this.executedKeyFrames.add(soundKeyFrame)) continue;
                event = new SoundKeyframeEvent<T>(this.animatable, tick, (String)soundKeyFrame.getEventData(), this);
                this.soundListener.playSound((SoundKeyframeEvent<T>)event);
            }
        }
        if (this.particleListener != null) {
            for (ParticleEventKeyFrame particleEventKeyFrame : this.currentAnimation.particleKeyFrames) {
                if (!(tick >= particleEventKeyFrame.getStartTick()) || !this.executedKeyFrames.add(particleEventKeyFrame)) continue;
                event = new ParticleKeyFrameEvent<T>(this.animatable, tick, particleEventKeyFrame.effect, particleEventKeyFrame.locator, particleEventKeyFrame.script, this);
                this.particleListener.summonParticle((ParticleKeyFrameEvent<T>)event);
            }
        }
        if (this.customInstructionListener != null) {
            for (EventKeyFrame customInstructionKeyFrame : this.currentAnimation.customInstructionKeyframes) {
                if (!(tick >= customInstructionKeyFrame.getStartTick()) || !this.executedKeyFrames.add(customInstructionKeyFrame)) continue;
                event = new CustomInstructionKeyframeEvent<T>(this.animatable, tick, (String)customInstructionKeyFrame.getEventData(), this);
                this.customInstructionListener.executeInstruction((CustomInstructionKeyframeEvent<T>)event);
            }
        }
        if (this.transitionLengthTicks == 0.0 && this.shouldResetTick && this.animationState == AnimationState.TRANSITIONING) {
            Pair<ILoopType, Animation> current = this.animationQueue.poll();
            if (current != null) {
                this.currentAnimation = (Animation)current.getRight();
                this.currentAnimationLoop = (ILoopType)current.getLeft();
            } else {
                this.currentAnimation = null;
            }
        }
    }

    private void switchAnimation() {
        this.activeBoneAnimationQueues.clear();
        for (BoneAnimation animation : this.currentAnimation.boneAnimations) {
            BoneAnimationQueue queue = (BoneAnimationQueue)this.boneAnimationQueues.get((Object)animation.boneName);
            if (queue == null) continue;
            queue.animation = animation;
            queue.updateSnapshot();
            queue.resetQueues();
            this.activeBoneAnimationQueues.add((Object)queue);
        }
    }

    private void switchRenderer(Map<String, BoneTopLevelSnapshot> modelRendererList) {
        this.boneAnimationQueues.clear();
        for (BoneTopLevelSnapshot modelRenderer : modelRendererList.values()) {
            this.boneAnimationQueues.put((Object)modelRenderer.name, (Object)new BoneAnimationQueue(modelRenderer));
        }
        this.activeBoneAnimationQueues.clear();
        this.markNeedsReload();
    }

    private void resetQueues() {
        for (BoneAnimationQueue queue : this.activeBoneAnimationQueues) {
            queue.resetQueues();
        }
    }

    public double adjustTick(double tick) {
        if (this.shouldResetTick) {
            if (this.getAnimationState() == AnimationState.TRANSITIONING) {
                this.tickOffset = tick;
            } else if (this.getAnimationState() == AnimationState.RUNNING) {
                this.tickOffset = tick;
            }
            this.shouldResetTick = false;
            return 0.0;
        }
        return this.animationSpeed * Math.max(tick - this.tickOffset, 0.0);
    }

    private AnimationPoint getAnimationPointAtTick(List<KeyFrame<IValue>> frames, double tick, boolean isRotation, Axis axis) {
        KeyFrameLocation<KeyFrame<IValue>> location = this.getCurrentKeyFrameLocation(frames, tick);
        Object currentFrame = location.currentFrame;
        double startValue = ((IValue)((KeyFrame)currentFrame).getStartValue()).get();
        double endValue = ((IValue)((KeyFrame)currentFrame).getEndValue()).get();
        if (isRotation) {
            if (!(((KeyFrame)currentFrame).getStartValue() instanceof ConstantValue)) {
                startValue = Math.toRadians(startValue);
                if (axis == Axis.X || axis == Axis.Y) {
                    startValue *= -1.0;
                }
            }
            if (!(((KeyFrame)currentFrame).getEndValue() instanceof ConstantValue)) {
                endValue = Math.toRadians(endValue);
                if (axis == Axis.X || axis == Axis.Y) {
                    endValue *= -1.0;
                }
            }
        }
        return new AnimationPoint((KeyFrame)currentFrame, location.currentTick, ((KeyFrame)currentFrame).getLength(), startValue, endValue);
    }

    private KeyFrameLocation<KeyFrame<IValue>> getCurrentKeyFrameLocation(List<KeyFrame<IValue>> frames, double ageInTicks) {
        double totalTimeTracker = 0.0;
        for (KeyFrame<IValue> frame : frames) {
            if (!((totalTimeTracker += frame.getLength().doubleValue()) > ageInTicks)) continue;
            double tick = ageInTicks - (totalTimeTracker - frame.getLength());
            return new KeyFrameLocation<KeyFrame<IValue>>(frame, tick);
        }
        return new KeyFrameLocation<KeyFrame<IValue>>(frames.get(frames.size() - 1), ageInTicks);
    }

    private void resetEventKeyFrames() {
        this.executedKeyFrames.clear();
    }

    public void markNeedsReload() {
        this.needsAnimationReload = true;
    }

    public void clearAnimationCache() {
        this.currentAnimationBuilder = new AnimationBuilder();
    }

    public double getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    @FunctionalInterface
    public static interface IAnimationPredicate<P extends AnimatableEntity<?>> {
        public PlayState test(AnimationEvent<P> var1);
    }

    @FunctionalInterface
    public static interface ISoundListener<A extends AnimatableEntity<?>> {
        public void playSound(SoundKeyframeEvent<A> var1);
    }

    @FunctionalInterface
    public static interface IParticleListener<A extends AnimatableEntity<?>> {
        public void summonParticle(ParticleKeyFrameEvent<A> var1);
    }

    @FunctionalInterface
    public static interface ICustomInstructionListener<A extends AnimatableEntity<?>> {
        public void executeInstruction(CustomInstructionKeyframeEvent<A> var1);
    }
}

