/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class EntityTombstone
extends Entity {
    public static final EntityType<EntityTombstone> TYPE = EntityType.Builder.m_20704_(EntityTombstone::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 1.2f).m_20702_(10).m_20712_("tombstone");
    private static final String OWNER_ID_TAG = "OwnerId";
    private static final String TOMBSTONE_ITEMS_TAG = "TombstoneItems";
    private static final String MAID_NAME_TAG = "MaidName";
    private static final EntityDataAccessor<Component> MAID_NAME = SynchedEntityData.m_135353_(EntityTombstone.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private final ItemStackHandler items = new ItemStackHandler(64);
    private UUID ownerId = Util.f_137441_;

    public EntityTombstone(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityTombstone(Level worldIn, UUID ownerId, Vec3 pos) {
        this(TYPE, worldIn);
        this.ownerId = ownerId;
        this.m_146884_(pos);
    }

    public void insertItem(ItemStack item) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.items, (ItemStack)item, (boolean)false);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        Ingredient ntrItem = EntityMaid.getNtrItem();
        if (player.m_20148_().equals(this.ownerId) || ntrItem.test(itemInHand)) {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                int size = this.items.getSlotLimit(i);
                ItemStack extractItem = this.items.extractItem(i, size, false);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extractItem);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!player.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = Arrays.stream(ntrItem.m_43908_()).findFirst().orElse(ItemStack.f_41583_);
            Component displayName = stack.m_41611_();
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.tombstone.not_yours.1"));
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.tombstone.not_yours.2").m_7220_(displayName));
        }
        return super.m_6096_(player, hand);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(MAID_NAME, (Object)Component.m_237119_());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_(OWNER_ID_TAG)) {
            this.ownerId = tag.m_128342_(OWNER_ID_TAG);
        }
        if (tag.m_128441_(TOMBSTONE_ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(TOMBSTONE_ITEMS_TAG));
        }
        if (tag.m_128441_(MAID_NAME_TAG)) {
            String nameJson = tag.m_128461_(MAID_NAME_TAG);
            this.setMaidName((Component)Component.Serializer.m_130701_((String)nameJson));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128362_(OWNER_ID_TAG, this.ownerId);
        tag.m_128365_(TOMBSTONE_ITEMS_TAG, (Tag)this.items.serializeNBT());
        tag.m_128359_(MAID_NAME_TAG, Component.Serializer.m_130703_((Component)this.getMaidName()));
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.m_146871_();
        }
    }

    public boolean m_7313_(Entity pEntity) {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
    }

    public void m_7334_(Entity entity) {
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public void m_6210_() {
    }

    public void m_142687_(Entity.RemovalReason reason) {
        MaidWorldData maidWorldData;
        if (reason.m_146965_() && (maidWorldData = MaidWorldData.get(this.f_19853_)) != null) {
            maidWorldData.removeTombstones(this);
        }
        super.m_142687_(reason);
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setMaidName(@Nullable Component name) {
        if (name != null) {
            this.f_19804_.m_135381_(MAID_NAME, (Object)name);
        }
    }

    public Component getMaidName() {
        return (Component)this.f_19804_.m_135370_(MAID_NAME);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }
}

