/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;

public class FurnaceBackpackData
extends SimpleContainer
implements IBackpackData {
    private static final int INPUT_INDEX = 0;
    private static final int FUEL_INDEX = 1;
    private static final int OUTPUT_INDEX = 2;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final RecipeManager.CachedCheck<Container, SmeltingRecipe> quickCheck;
    private final Level level;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> FurnaceBackpackData.this.litTime;
                case 1 -> FurnaceBackpackData.this.litDuration;
                case 2 -> FurnaceBackpackData.this.cookingProgress;
                case 3 -> FurnaceBackpackData.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceBackpackData.this.litTime = value;
                    break;
                }
                case 1: {
                    FurnaceBackpackData.this.litDuration = value;
                    break;
                }
                case 2: {
                    FurnaceBackpackData.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    FurnaceBackpackData.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public FurnaceBackpackData(EntityMaid maid) {
        super(3);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_);
        this.level = maid.f_19853_;
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(CompoundTag tag, EntityMaid maid) {
        this.litTime = tag.m_128451_("BurnTime");
        this.cookingProgress = tag.m_128451_("CookTime");
        this.cookingTotalTime = tag.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.m_8020_(1));
        this.m_7797_(tag.m_128437_("Items", 10));
    }

    @Override
    public void save(CompoundTag tag, EntityMaid maid) {
        tag.m_128405_("BurnTime", this.litTime);
        tag.m_128405_("CookTime", this.cookingProgress);
        tag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        tag.m_128365_("Items", (Tag)this.m_7927_());
    }

    @Override
    public void serverTick(EntityMaid maid) {
        boolean readyForLit;
        Level level = maid.m_9236_();
        if (this.isLit()) {
            --this.litTime;
        }
        ItemStack fuelItem = this.m_8020_(1);
        boolean inputNotEmpty = !this.m_8020_(0).m_41619_();
        boolean fuelNotEmpty = !fuelItem.m_41619_();
        boolean bl = readyForLit = inputNotEmpty && fuelNotEmpty;
        if (this.isLit() || readyForLit) {
            SmeltingRecipe recipe = inputNotEmpty ? (SmeltingRecipe)this.quickCheck.m_213657_((Container)this, level).orElse(null) : null;
            int maxStackSize = this.m_6893_();
            if (!this.isLit() && this.canBurn(level.m_9598_(), recipe, this, maxStackSize)) {
                this.litDuration = this.litTime = this.getBurnDuration(fuelItem);
                if (this.isLit()) {
                    if (fuelItem.hasCraftingRemainingItem()) {
                        this.m_6836_(1, fuelItem.getCraftingRemainingItem());
                    } else if (fuelNotEmpty) {
                        fuelItem.m_41774_(1);
                        if (fuelItem.m_41619_()) {
                            this.m_6836_(1, fuelItem.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(level.m_9598_(), recipe, this, maxStackSize)) {
                ++this.cookingProgress;
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = this.getTotalCookTime(level);
                    if (this.burn(level.m_9598_(), recipe, this, maxStackSize)) {
                        int exp = this.createExperience(recipe.m_43750_());
                        maid.setExperience(maid.getExperience() + exp);
                    }
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (this.cookingProgress > 0) {
            this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack slotItem = this.m_8020_(index);
        boolean isSameItem = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)stack);
        super.m_6836_(index, stack);
        if (index == 0 && !isSameItem) {
            this.cookingTotalTime = this.getTotalCookTime(this.level);
            this.cookingProgress = 0;
        }
    }

    private int createExperience(float recipeExp) {
        int integer = Mth.m_14143_((float)recipeExp);
        float decimal = Mth.m_14187_((float)recipeExp);
        if (decimal != 0.0f && Math.random() < (double)decimal) {
            ++integer;
        }
        return integer;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private int getBurnDuration(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
    }

    private boolean canBurn(RegistryAccess access, @Nullable SmeltingRecipe recipe, SimpleContainer container, int maxStackSize) {
        if (!container.m_8020_(0).m_41619_() && recipe != null) {
            ItemStack result = recipe.m_5874_((Container)this, access);
            if (result.m_41619_()) {
                return false;
            }
            ItemStack output = container.m_8020_(2);
            if (output.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)output, (ItemStack)result)) {
                return false;
            }
            if (output.m_41613_() + result.m_41613_() <= maxStackSize && output.m_41613_() + result.m_41613_() <= output.m_41741_()) {
                return true;
            }
            return output.m_41613_() + result.m_41613_() <= result.m_41741_();
        }
        return false;
    }

    private boolean burn(RegistryAccess access, @Nullable SmeltingRecipe recipe, SimpleContainer container, int maxStackSize) {
        if (recipe != null && this.canBurn(access, recipe, container, maxStackSize)) {
            ItemStack input = container.m_8020_(0);
            ItemStack result = recipe.m_5874_((Container)this, access);
            ItemStack output = container.m_8020_(2);
            if (output.m_41619_()) {
                container.m_6836_(2, result.m_41777_());
            } else if (output.m_150930_(result.m_41720_())) {
                output.m_41769_(result.m_41613_());
            }
            if (input.m_150930_(Blocks.f_50057_.m_5456_()) && !container.m_8020_(1).m_41619_() && container.m_8020_(1).m_150930_(Items.f_42446_)) {
                container.m_6836_(1, new ItemStack((ItemLike)Items.f_42447_));
            }
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    private int getTotalCookTime(Level level) {
        return this.quickCheck.m_213657_((Container)this, level).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }
}

