/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class MaidDebugCommand {
    private static final String MAID_DEBUG_NAME = "debug";
    private static final String SPAWN_MAID = "spawn_maid";
    private static final String COUNT_NAME = "count";
    private static final String MODEL_ID = "model_id";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder debug = Commands.m_82127_((String)MAID_DEBUG_NAME);
        LiteralArgumentBuilder spawnMaid = Commands.m_82127_((String)SPAWN_MAID);
        RequiredArgumentBuilder modelId = Commands.m_82129_((String)MODEL_ID, (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder count = Commands.m_82129_((String)COUNT_NAME, (ArgumentType)IntegerArgumentType.integer((int)0));
        debug.then(spawnMaid.then(modelId.then(count.executes(MaidDebugCommand::spawnMaid))));
        return debug;
    }

    private static int spawnMaid(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String modelId = StringArgumentType.getString(context, (String)MODEL_ID);
        int count = IntegerArgumentType.getInteger(context, (String)COUNT_NAME);
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                BlockPos blockPos = serverPlayer.m_20183_();
                int x = blockPos.m_123341_() + i % 10 + 1;
                int z = blockPos.m_123343_() + i / 10 + 1;
                EntityMaid entityMaid = new EntityMaid(serverPlayer.f_19853_);
                entityMaid.m_6034_(x, blockPos.m_123342_(), z);
                entityMaid.m_21828_((Player)serverPlayer);
                entityMaid.setModelId(modelId);
                entityMaid.m_21837_(true);
                serverPlayer.f_19853_.m_7967_((Entity)entityMaid);
            }
        }
        return 1;
    }
}

