/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.resource.GeckoModelLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChatBubbleInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.google.common.collect.Lists;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MaidModelInfo
implements IModelInfo {
    public static final String ENCRYPT_EGG_NAME = "{gui.touhou_little_maid.model_gui.easter_egg.encrypt}";
    public static final String NORMAL_EGG_NAME = "{gui.touhou_little_maid.model_gui.easter_egg.normal}";
    private static final float RENDER_ENTITY_SCALE_MIN = 0.2f;
    private static final float RENDER_ENTITY_SCALE_MAX = 2.0f;
    private static final String GECKO_ANIMATION = ".json";
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private List<String> description;
    @SerializedName(value="chat_bubble")
    private ChatBubbleInfo chatBubble = ChatBubbleManger.DEFAULT_CHAT_BUBBLE;
    @SerializedName(value="model")
    private ResourceLocation model;
    @SerializedName(value="texture")
    private ResourceLocation texture;
    @SerializedName(value="extra_textures")
    private List<ResourceLocation> extraTextures;
    @SerializedName(value="model_id")
    private ResourceLocation modelId;
    @SerializedName(value="use_sound_pack_id")
    private String useSoundPackId;
    @SerializedName(value="render_item_scale")
    private float renderItemScale = 1.0f;
    @SerializedName(value="render_entity_scale")
    private float renderEntityScale = 1.0f;
    @SerializedName(value="animation")
    private List<ResourceLocation> animation;
    @SerializedName(value="show_hata")
    private boolean showHata = true;
    @SerializedName(value="show_backpack")
    private boolean showBackpack = true;
    @SerializedName(value="show_custom_head")
    private boolean showCustomHead = true;
    @SerializedName(value="can_hold_trolley")
    private boolean canHoldTrolley = true;
    @SerializedName(value="can_hold_vehicle")
    private boolean canHoldVehicle = true;
    @SerializedName(value="can_riding_broom")
    private boolean canRidingBroom = true;
    @SerializedName(value="easter_egg")
    private EasterEgg easterEgg = null;
    @SerializedName(value="is_gecko")
    private boolean isGeckoModel = false;
    @Expose(deserialize=false, serialize=false)
    private ResourceLocation cacheIconId = null;

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public List<ResourceLocation> getExtraTextures() {
        return this.extraTextures;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    public ChatBubbleInfo getChatBubble() {
        return this.chatBubble;
    }

    @Override
    public List<ResourceLocation> getAnimation() {
        return this.animation;
    }

    @Override
    public ResourceLocation getModelId() {
        return this.modelId;
    }

    @Nullable
    public String getUseSoundPackId() {
        return this.useSoundPackId;
    }

    @Override
    public ResourceLocation getModel() {
        return this.model;
    }

    @Override
    public boolean isGeckoModel() {
        return this.isGeckoModel;
    }

    @Override
    public float getRenderItemScale() {
        return this.renderItemScale;
    }

    public float getRenderEntityScale() {
        return this.renderEntityScale;
    }

    @Deprecated
    public boolean isShowHata() {
        return this.showHata;
    }

    public boolean isShowBackpack() {
        return this.showBackpack;
    }

    public boolean isShowCustomHead() {
        return this.showCustomHead;
    }

    @Deprecated
    public boolean isCanHoldTrolley() {
        return this.canHoldTrolley;
    }

    @Deprecated
    public boolean isCanHoldVehicle() {
        return this.canHoldVehicle;
    }

    @Deprecated
    public boolean isCanRidingBroom() {
        return this.canRidingBroom;
    }

    @Nullable
    public EasterEgg getEasterEgg() {
        return this.easterEgg;
    }

    @Override
    public ResourceLocation getCacheIconId() {
        return this.cacheIconId;
    }

    public MaidModelInfo extra(ResourceLocation newModelId, ResourceLocation texture) {
        MaidModelInfo cloneInfo = new MaidModelInfo();
        cloneInfo.modelId = newModelId;
        cloneInfo.texture = texture;
        cloneInfo.cacheIconId = IModelInfo.createCacheIconId(newModelId);
        cloneInfo.name = this.name;
        cloneInfo.description = this.description;
        cloneInfo.chatBubble = this.chatBubble;
        cloneInfo.model = this.model;
        cloneInfo.useSoundPackId = this.useSoundPackId;
        cloneInfo.renderItemScale = this.renderItemScale;
        cloneInfo.renderEntityScale = this.renderEntityScale;
        cloneInfo.animation = this.animation;
        cloneInfo.showHata = this.showHata;
        cloneInfo.showBackpack = this.showBackpack;
        cloneInfo.showCustomHead = this.showCustomHead;
        cloneInfo.canHoldTrolley = this.canHoldTrolley;
        cloneInfo.canHoldVehicle = this.canHoldVehicle;
        cloneInfo.canRidingBroom = this.canRidingBroom;
        cloneInfo.easterEgg = this.easterEgg;
        cloneInfo.isGeckoModel = this.isGeckoModel;
        return cloneInfo;
    }

    public MaidModelInfo decorate() {
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.modelId == null) {
            throw new JsonSyntaxException("Expected \"model_id\" in model");
        }
        this.cacheIconId = IModelInfo.createCacheIconId(this.modelId);
        if (this.model == null) {
            this.model = new ResourceLocation(this.modelId.m_135827_(), "models/entity/" + this.modelId.m_135815_() + GECKO_ANIMATION);
        }
        if (this.texture == null) {
            this.texture = new ResourceLocation(this.modelId.m_135827_(), "textures/entity/" + this.modelId.m_135815_() + ".png");
        }
        if (this.easterEgg != null) {
            this.name = this.easterEgg.isEncrypt() ? ENCRYPT_EGG_NAME : NORMAL_EGG_NAME;
        }
        if (this.name == null) {
            this.name = String.format("{model.%s.%s.name}", this.modelId.m_135827_(), this.modelId.m_135815_());
        }
        if (this.isGeckoModel) {
            this.animation = this.animation == null || this.animation.isEmpty() ? Collections.singletonList(GeckoModelLoader.DEFAULT_MAID_ANIMATION) : this.animation.stream().filter(res -> res.m_135815_().endsWith(GECKO_ANIMATION)).collect(Collectors.toList());
        } else if (this.animation == null || this.animation.isEmpty()) {
            this.animation = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("touhou_little_maid", "animation/maid/default/head/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/blink.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/beg.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/head/music_shake.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/leg/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/swing.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/arm/vertical.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/sit/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/armor/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/armor/reverse.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/wing/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/tail/default.js"), new ResourceLocation("touhou_little_maid", "animation/maid/default/sit/skirt_rotation.js"), new ResourceLocation("touhou_little_maid", "animation/base/float/default.js")});
        }
        this.renderEntityScale = Mth.m_14036_((float)this.renderEntityScale, (float)0.2f, (float)2.0f);
        if (this.chatBubble == null) {
            this.chatBubble = ChatBubbleManger.DEFAULT_CHAT_BUBBLE;
        } else if (this.chatBubble != ChatBubbleManger.DEFAULT_CHAT_BUBBLE) {
            this.chatBubble.decorate();
        }
        return this;
    }

    public static class EasterEgg {
        @SerializedName(value="encrypt")
        private boolean encrypt = false;
        @SerializedName(value="tag")
        private String tag = "";

        public boolean isEncrypt() {
            return this.encrypt;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

