/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityYukkuriModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Slime;

public class EntityYukkuriSlimeRender
extends MobRenderer<Slime, EntityYukkuriModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/yukkuri.png");
    private final SlimeRenderer vanillaRender;

    public EntityYukkuriSlimeRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EntityYukkuriModel(context.m_174023_(EntityYukkuriModel.LAYER)), 0.25f);
        this.vanillaRender = new SlimeRenderer(context);
    }

    public void render(Slime slime, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_SLIME_MODEL.get()).booleanValue()) {
            this.renderYukkuri(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.m_7392_(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderYukkuri(Slime slime, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = 0.25f * (float)slime.m_33632_();
        super.m_7392_((Mob)slime, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(Slime slime, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(0.999f, 0.999f, 0.999f);
        poseStack.m_252880_(0.0f, 0.001f, 0.0f);
        float slimeSize = slime.m_33632_();
        float tmp = Mth.m_14179_((float)partialTicks, (float)slime.f_33585_, (float)slime.f_33584_) / (slimeSize * 0.5f + 1.0f);
        float scale = 1.0f / (tmp + 1.0f);
        poseStack.m_85841_(scale * slimeSize, 1.0f / scale * slimeSize, scale * slimeSize);
    }

    public ResourceLocation getTextureLocation(Slime slime) {
        return TEXTURE;
    }
}

