/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model.bedrock;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Random;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BedrockPart {
    public final ObjectList<BedrockCube> cubes = new ObjectArrayList();
    private final ObjectList<BedrockPart> children = new ObjectArrayList();
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public boolean visible = true;
    public boolean mirror;
    private float initRotX;
    private float initRotY;
    private float initRotZ;

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int texU, int texV) {
        this.render(poseStack, consumer, texU, texV, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            poseStack.m_85836_();
            poseStack.m_252880_(this.offsetX, this.offsetY, this.offsetZ);
            this.translateAndRotate(poseStack);
            this.compile(poseStack.m_85850_(), consumer, texU, texV, red, green, blue, alpha);
            for (BedrockPart part : this.children) {
                part.render(poseStack, consumer, texU, texV, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.m_252880_(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.zRot != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252961_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252961_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252961_(this.xRot));
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        for (BedrockCube bedrockCube : this.cubes) {
            bedrockCube.compile(pose, consumer, texU, texV, red, green, blue, alpha);
        }
    }

    public BedrockCube getRandomCube(Random random) {
        return (BedrockCube)this.cubes.get(random.nextInt(this.cubes.size()));
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public void setInitRotationAngle(float x, float y, float z) {
        this.initRotX = x;
        this.initRotY = y;
        this.initRotZ = z;
    }

    public float getInitRotX() {
        return this.initRotX;
    }

    public float getInitRotY() {
        return this.initRotY;
    }

    public float getInitRotZ() {
        return this.initRotZ;
    }

    public void addChild(BedrockPart model) {
        this.children.add((Object)model);
    }
}

